% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img_update_all.R
\name{img_update_all}
\alias{img_update_all}
\title{Update the images for all samples}
\usage{
img_update_all(
  spe,
  image_id = "lowres",
  new_image_id = paste0("edited_", image_id),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{new_image_id}{A \code{character(1)} specifying the new \code{image_id} to use.}

\item{overwrite}{A \code{logical(1)} specifying whether to overwrite the
\code{image_id} if it already exists.}

\item{...}{Parameters passed to \code{img_edit()}.}
}
\value{
A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}  object
with an updated \code{imgData()} slot.
}
\description{
This function uses \code{img_update()} for all samples. That is, it loops through
every sample and edits the image with \code{img_edit()} and then updates the
\code{imgData()}.
}
\examples{
if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Reduce brightness to 25\% for the 'lowres' image for all samples and
    ## update the imgData()
    imgData(img_update_all(spe, brightness = 25))
}
}
\seealso{
Other Image editing functions: 
\code{\link{img_edit}()},
\code{\link{img_update}()}
}
\concept{Image editing functions}
