% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read10xVisiumWrapper.R
\name{read10xVisiumWrapper}
\alias{read10xVisiumWrapper}
\title{Load data from a 10x Genomics Visium experiment and make it spatialLIBD-ready}
\usage{
read10xVisiumWrapper(
  samples = "",
  sample_id = paste0("sample", sprintf("\%02d", seq_along(samples))),
  type = c("HDF5", "sparse"),
  data = c("filtered", "raw"),
  images = c("lowres", "hires", "detected", "aligned"),
  load = TRUE,
  reference_gtf = NULL,
  chrM = "chrM",
  gtf_cols = c("source", "type", "gene_id", "gene_version", "gene_name", "gene_type"),
  verbose = TRUE
)
}
\arguments{
\item{samples}{Passed to \code{\link[SpatialExperiment:read10xVisium]{SpatialExperiment::read10xVisium()}}.}

\item{sample_id}{Passed to \code{\link[SpatialExperiment:read10xVisium]{SpatialExperiment::read10xVisium()}}.}

\item{type}{Passed to \code{\link[SpatialExperiment:read10xVisium]{SpatialExperiment::read10xVisium()}}.}

\item{data}{Passed to \code{\link[SpatialExperiment:read10xVisium]{SpatialExperiment::read10xVisium()}}.}

\item{images}{Passed to \code{\link[SpatialExperiment:read10xVisium]{SpatialExperiment::read10xVisium()}}.}

\item{load}{Passed to \code{\link[SpatialExperiment:read10xVisium]{SpatialExperiment::read10xVisium()}}.}

\item{reference_gtf}{A \code{character(1)} specifying the path to the reference
\code{genes.gtf} file. If not specified, it will be automatically inferred from
the \code{web_summary.html} file for the first \code{samples}.}

\item{chrM}{A \code{character(1)} specifying the chromosome name of the
mitochondrial chromosome. Defaults to \code{chrM}.}

\item{gtf_cols}{A \code{character()} specifying which columns to keep from the GTF
file. \code{"gene_name"} and \code{"gene_id"} have to be included in \code{gtf_cols}.}

\item{verbose}{A \code{logical(1)} specifying whether to show progress updates.}
}
\value{
A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment} object with the
clustering and dimension reduction (projection) results from SpaceRanger by
10x Genomics as well as other information used by \code{run_app()} for visualzing
the gene expression data.
}
\description{
This function expands \code{\link[SpatialExperiment:read10xVisium]{SpatialExperiment::read10xVisium()}} to include
analysis results from SpaceRanger by 10x Genomics as well as add information
needed by \code{run_app()} to visualize the data with the \code{spatialLIBD} shiny
web application.
}
\examples{
## See 'Using spatialLIBD with 10x Genomics public datasets' for
## a full example using this function.
if (interactive()) {
    browseVignettes(package = "spatialLIBD")
}

## Note that ?SpatialExperiment::read10xVisium doesn't include all the files
## we need to illustrate read10xVisiumWrapper().
}
\seealso{
Other Utility functions for reading data from SpaceRanger output by 10x
Genomics: 
\code{\link{add10xVisiumAnalysis}()},
\code{\link{read10xVisiumAnalysis}()}
}
\concept{Utility functions for reading data from SpaceRanger output by 10x
Genomics}
