% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration_stats_pairwise.R
\name{registration_stats_pairwise}
\alias{registration_stats_pairwise}
\title{Spatial registration: compute pairwise statistics}
\usage{
registration_stats_pairwise(
  sce_pseudo,
  registration_model,
  block_cor,
  var_registration = "registration_variable",
  var_sample_id = "registration_sample_id",
  gene_ensembl = NULL,
  gene_name = NULL
)
}
\arguments{
\item{sce_pseudo}{The output of \code{registration_pseudobulk()}.}

\item{registration_model}{The output from \code{registration_model()}.}

\item{block_cor}{A \code{numeric(1)} computed with \code{registration_block_cor()}.}

\item{var_registration}{A \code{character(1)} specifying the \code{colData(sce_pseudo)}
variable of interest against which will be used for computing the relevant
statistics.}

\item{var_sample_id}{A \code{character(1)} specifying the \code{colData(sce_pseudo)}
variable with the sample ID.}

\item{gene_ensembl}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the ENSEMBL gene IDs. This will be used by \code{layer_stat_cor()}.}

\item{gene_name}{A \code{character(1)} specifying the \code{rowData(sce_pseudo)}
column with the gene names (symbols).}
}
\value{
A \code{data.frame()} with the pairwise statistical results. This is
similar to \code{fetch_data("modeling_results")$pairwise}.
}
\description{
This function computes the gene pairwise t-statistics (one group > another,
for all combinations). These t-statistics can be used for spatial
registration with \code{layer_stat_cor()} and related functions. Although, they
are more typically used for identifying pairwise-marker genes.
}
\examples{
example("registration_block_cor", package = "spatialLIBD")
results_pairwise <- registration_stats_pairwise(sce_pseudo,
    registration_mod, block_cor,
    gene_ensembl = "ensembl", gene_name = "gene_name"
)
head(results_pairwise)

## Specifying `block_cor = NaN` then ignores the correlation structure
results_pairwise_nan <- registration_stats_pairwise(sce_pseudo,
    registration_mod,
    block_cor = NaN,
    gene_ensembl = "ensembl", gene_name = "gene_name"
)
head(results_pairwise_nan)
}
\seealso{
Other spatial registration and statistical modeling functions: 
\code{\link{registration_block_cor}()},
\code{\link{registration_model}()},
\code{\link{registration_pseudobulk}()},
\code{\link{registration_stats_anova}()},
\code{\link{registration_stats_enrichment}()},
\code{\link{registration_wrapper}()}
}
\concept{spatial registration and statistical modeling functions}
