% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functional_hunter.R
\name{main_functional_hunter}
\alias{main_functional_hunter}
\title{Perform Functional analysis with different
enrichment corpora.}
\usage{
main_functional_hunter(
  hunter_results,
  model_organism,
  annot_table = NULL,
  organisms_table = get_organism_table(),
  input_gene_id = "ENSEMBL",
  custom = NULL,
  enrich_dbs = c("MF", "Reactome"),
  kegg_data_file = "",
  enrich_methods = "ORA",
  annotation_source = "orgdb",
  pthreshold = 0.1,
  qthreshold = 0.2,
  cores = 1,
  task_size = 1,
  output_files = "results",
  fc_colname = "mean_logFCs",
  universe = NULL,
  clean_parentals = FALSE,
  simplify = FALSE,
  top_categories = 50,
  sim_thr = NULL,
  summary_common_name = "ancestor",
  clusters_flag = FALSE
)
}
\arguments{
\item{hunter_results}{output of main_degenes_hunter - list with DEG analysis results}

\item{model_organism}{organisms which genes are being studied}

\item{annot_table}{(OPTIONAL) annotation table to translate gene IDs}

\item{organisms_table}{(OPTIONAL) configuration table for given organism.
Use see get_organism_table()}

\item{input_gene_id}{(OPTIONAL) type og gene IDs given. Allowed: ENSEMBL (E)
, entrezgene (e), TAIR/Arabidopsis (T), Gene Names (G).}

\item{custom}{(OPTIONAL) list of dataframes with GMT corpus}

\item{enrich_dbs}{annotation dbs to be used: BP,MF,CC,Reactome,KEGG
\itemize{
\item MF and Reactome default
}}

\item{kegg_data_file}{if KEGG included in enrich_dbs path needs}

\item{enrich_methods}{enrichment methods to be used: ORA or GSEA}

\item{annotation_source}{annote with orgdbs or Biomart? Currently on orgdbs}

\item{pthreshold}{pvalue threshold}

\item{qthreshold}{qvalue threshold}

\item{cores}{cores to be used if parallel features are going to be used.
Default: 1}

\item{task_size}{number of elements per packages used}

\item{output_files}{output folder}

\item{fc_colname}{main logFC colname (into hunter_results dataframe)}

\item{universe}{whether to use all genes as the background, or expressed only}

\item{clean_parentals}{clean parental terms in merged enrichment}

\item{simplify}{simplify the merged enrichments}

\item{top_categories}{numbers of categories from each cluster to use for merge}

\item{sim_thr}{value to use when combining similar categories in summary mode}

\item{summary_common_name}{'significant' to use the most significant term to label each summarized group}

\item{clusters_flag}{execute clusters enrichments}
}
\value{
functional result object with enrichments performed
}
\description{
Perform Functional analysis with different
enrichment corpora.
}
\examples{
# Load DE analysis result
data(degh_output)
func_results <- main_functional_hunter(hunter_results = degh_output,
model_organism = "Mouse", enrich_dbs = "MF")
}
\keyword{method}
