% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suvara.R
\name{surVarAnaly}
\alias{surVarAnaly}
\title{Estimate surrogate covariates unmodeled or hidden in the data}
\usage{
surVarAnaly(expSetobj, blgy_var, n.sv = NULL)
}
\arguments{
\item{expSetobj}{Expression set object}

\item{blgy_var}{biological variable of interest}

\item{n.sv}{number of surrogate variables to be estimated (if no argument
provided then the algorithm estimates n.sv for the user)}
}
\value{
sv A n by n.sv matrix where each column is a distinct surrogate 
variable (the main quantity of interest)

pprob.gam   posterior probability that each gene is associated with one or more latent variables

pprob.b  posterior probability that each gene is associated with the variables of interest b

n.sv  The number of surrogate variables estimated, Enter if n.sv 
known or just dont enter the parameter, the tool will identify the number of surrogate variables on its own

expSetobject Modified expression set object with the surrogate 
variables added as additional columns to covariate matrix
}
\description{
Surrogate variables are covariates constructed directly from 
high-dimensional data (like gene expression/RNA sequencing/methylation/brain imaging data)
that can be used in subsequent analyses to adjust for unknown, unmodeled, or latent sources of noise.
}
\note{
The return values of the function can be accessed as <variable>$<parameter>
}
\author{
Karthikeyan  Murugesan <karthikeyanm60 at yahoo.com>
}
\references{
Leek JT, Johnson WE, Parker HS, Fertig EJ, Jaffe AE and Storey JD.
sva: Surrogate Variable Analysis. R package version 3.12.0.
}
\seealso{
\code{\link{sva}}
#@examples surVarAnaly(expSetobj, blgy_var, adj_var)
}
\keyword{Analysis,}
\keyword{SVA}
\keyword{Surrogate}
\keyword{Variable}

