## ----style, echo=FALSE, results='hide', message=FALSE, cache=FALSE------------
library(BiocStyle)
library(knitr)
opts_chunk$set(error=FALSE, message=FALSE, warning=FALSE, cache=TRUE)
opts_chunk$set(fig.asp=1)

## -----------------------------------------------------------------------------
library(BiocFileCache)
bfc <- BiocFileCache("raw_data", ask=FALSE)
wilson.fname <- bfcrpath(bfc, file.path("ftp://ftp.ncbi.nlm.nih.gov/geo/series",
    "GSE61nnn/GSE61533/suppl/GSE61533_HTSEQ_count_results.xls.gz"))
library(R.utils)
wilson.name2 <- "GSE61533_HTSEQ_count_results.xls"
gunzip(wilson.fname, destname=wilson.name2, remove=FALSE, overwrite=TRUE)

library(readxl)
all.counts <- read_excel(wilson.name2)
gene.names <- all.counts$ID
all.counts <- as.matrix(all.counts[,-1])
rownames(all.counts) <- gene.names

library(SingleCellExperiment)
sce.hsc <- SingleCellExperiment(list(counts=all.counts))
is.spike <- grepl("^ERCC", rownames(sce.hsc))
sce.hsc <- splitAltExps(sce.hsc, ifelse(is.spike, "ERCC", "gene"))

library(scater)
sce.hsc <- addPerCellQC(sce.hsc)
spike.drop <- quickPerCellQC(colData(sce.hsc))
sce.hsc <- sce.hsc[,!spike.drop$discard]

library(scran)
sce.hsc <- computeSumFactors(sce.hsc)
sce.hsc <- logNormCounts(sce.hsc)

## -----------------------------------------------------------------------------
set.seed(100)
var.cor <- correlatePairs(sce.hsc, subset.row=grep("^H2-", rownames(sce.hsc)))
head(var.cor)

## -----------------------------------------------------------------------------
sig.cor <- var.cor$FDR <= 0.05
summary(sig.cor)

## -----------------------------------------------------------------------------
correlatePairs(sce.hsc, subset.row=cbind("Fos", "Jun"))

## ----fosjuncorplot, fig.cap="Expression of _Fos_ plotted against the expression of _Jun_ for all cells in the HSC dataset."----
library(scater)
plotExpression(sce.hsc, features="Fos", x="Jun")

## -----------------------------------------------------------------------------
ave.counts <- calculateAverage(sce.hsc)
demo.keep <- ave.counts >= 1
filtered.sce.hsc <- sce.hsc[demo.keep,]
summary(demo.keep)

## -----------------------------------------------------------------------------
sessionInfo()

