% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setupHTML.R
\name{setupHTML}
\alias{setupHTML}
\title{Set up HTML elements}
\usage{
setupHTML()
}
\value{
Prints HTML to set up JS and CSS elements.
}
\description{
Set up Javascript and CSS elements for the custom collapsible class.
}
\details{
The custom collapsible class allows us to hide details until requested by the user.
This improves readability by reducing the clutter in the compiled chapter.
}
\examples{
tmp <- tempfile(fileext=".Rmd")
write(file=tmp, "```{r, echo=FALSE, results='asis'}
rebook::setupHTML()
```

```{r, results='asis'}
prettySessionInfo()
```")

rmarkdown::render(tmp)

if (interactive()) browseURL(sub(".Rmd$", ".html", tmp))

}
\seealso{
\code{\link{chapterPreamble}}, which calls this function.

\code{\link{extractCached}} and \code{\link{prettySessionInfo}}, which use the custom collapsible class.
}
\author{
Aaron Lun
}
