/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import eponine.model.BundleConstraint;
import eponine.model.Constraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.DiscreteDistribution;
import eponine.model.EponineXML;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.WeightMatrixConstraint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.gui.DNAStyle;
import org.biojava.bio.gui.DistributionLogo;
import org.biojava.bio.gui.TextLogoPainter;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.scenegraph.ChildManager;
import org.biojava.utils.scenegraph.Component;
import org.biojava.utils.scenegraph.Composite;
import org.biojava.utils.scenegraph.CompositeRectangularBorder;
import org.biojava.utils.scenegraph.Primative;
import org.biojava.utils.xml.AppEntry;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import stats.glm.BasisFunction;
import stats.glm.GLMClassificationModel;

public class ModelViewerSG
implements AppEntry {
    private String fileName;
    private Font motifFont = new Font("Helvetica", 0, 8);
    private Map componentToWeightMatrix = new HashMap();
    private Map componentToRuleDescriptions = new HashMap();

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void start(String[] stringArray) {
        try {
            EponineXML eponineXML = new EponineXML();
            InputSource inputSource = new InputSource(new FileInputStream(this.fileName));
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            GLMClassificationModel gLMClassificationModel = eponineXML.xmlToModel(document.getDocumentElement());
            JFrame jFrame = new JFrame("Eponine ModelViewer");
            final ModelPanel modelPanel = new ModelPanel(gLMClassificationModel);
            jFrame.getContentPane().add(new JScrollPane(modelPanel));
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("Viewer");
            jMenu.add(new AbstractAction("Print..."){

                public void actionPerformed(ActionEvent actionEvent) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    Book book = new Book();
                    book.append(modelPanel, printerJob.defaultPage());
                    printerJob.setPageable(book);
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            printerException.printStackTrace();
                        }
                    }
                }
            });
            jMenu.add(new AbstractAction("Quit"){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            jMenuBar.add(jMenu);
            jFrame.setJMenuBar(jMenuBar);
            ((java.awt.Component)jFrame).setSize(600, 400);
            ((java.awt.Component)jFrame).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Component layoutPanel(Graphics2D graphics2D, GLMClassificationModel gLMClassificationModel) {
        Object object;
        Object object2;
        Composite composite = new Composite();
        ChildManager childManager = composite.getChildManager();
        ArrayList<PositionedConstraintWithWeight> arrayList = new ArrayList<PositionedConstraintWithWeight>();
        Iterator iterator = gLMClassificationModel.getBasisFunctions().iterator();
        while (iterator.hasNext()) {
            object2 = (BasisFunction)iterator.next();
            if (!(object2 instanceof ConstraintBasisFunction) || !((object = ((ConstraintBasisFunction)object2).getConstraint()) instanceof PositionedConstraint)) continue;
            PositionedConstraintWithWeight positionedConstraintWithWeight = new PositionedConstraintWithWeight();
            positionedConstraintWithWeight.pc = (PositionedConstraint)object;
            positionedConstraintWithWeight.weight = gLMClassificationModel.getWeight((BasisFunction)object2);
            arrayList.add(positionedConstraintWithWeight);
        }
        object2 = this.makeModelGraph(graphics2D, arrayList);
        childManager.insert(-1000000, (Component)object2);
        object = new Primative(new Polygon(new int[]{-10, 10, 0}, new int[]{-14, -14, 0}, 3));
        ((Component)object).getGraphicsChanges().paint = Color.blue;
        childManager.insert(-1000000, (Component)object);
        return composite;
    }

    private Component makeModelGraph(Graphics2D graphics2D, List list) {
        Component component;
        Object object;
        CompositeRectangularBorder compositeRectangularBorder = new CompositeRectangularBorder();
        compositeRectangularBorder.getGraphicsChanges().stroke = new BasicStroke(0.25f);
        ChildManager childManager = compositeRectangularBorder.getChildManager();
        int n = 0;
        int n2 = 0;
        graphics2D.setFont(new Font("Helvetica", 0, 24));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3;
            Object object4;
            object = (PositionedConstraintWithWeight)iterator.next();
            component = new CompositeRectangularBorder();
            ChildManager childManager2 = ((Composite)component).getChildManager();
            int n3 = ((PositionedConstraintWithWeight)object).pc.getPosition();
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
            DiscreteDistribution discreteDistribution = ((PositionedConstraintWithWeight)object).pc.getDistribution();
            Shape shape = this.drawDistribution(discreteDistribution);
            Primative primative = new Primative(shape);
            primative.setDrawMode(Primative.DrawMode.FILL);
            if (((PositionedConstraintWithWeight)object).weight < 0.0) {
                primative.getGraphicsChanges().paint = Color.blue;
            }
            childManager2.insert(-1000000, primative);
            Constraint constraint = ((PositionedConstraintWithWeight)object).pc.getConstraint();
            if (constraint instanceof WeightMatrixConstraint) {
                WeightMatrix weightMatrix = ((WeightMatrixConstraint)constraint).getWeightMatrix();
                double d = ((WeightMatrixConstraint)constraint).getReversibility();
                object4 = this.wmToMotif(weightMatrix);
                object3 = this.motifFont.createGlyphVector(graphics2D.getFontRenderContext(), (String)object4).getOutline(0.0f, 18.0f);
                Primative primative2 = new Primative((Shape)object3);
                this.translateComponent(primative2, object3.getBounds2D().getWidth() * -0.5, 0.0);
                primative2.setDrawMode(Primative.DrawMode.FILL);
                childManager2.insert(-1000000, primative2);
                this.componentToWeightMatrix.put(primative, weightMatrix);
                this.componentToRuleDescriptions.put(primative, "" + n3 + "; weight=" + ((PositionedConstraintWithWeight)object).weight + "; reverse=" + d);
            } else if (constraint instanceof BundleConstraint) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator2 = ((BundleConstraint)constraint).getConstraints().iterator();
                while (iterator2.hasNext()) {
                    object2 = (Constraint)iterator2.next();
                    object4 = new PositionedConstraintWithWeight();
                    ((PositionedConstraintWithWeight)object4).pc = (PositionedConstraint)object2;
                    ((PositionedConstraintWithWeight)object4).weight = ((PositionedConstraintWithWeight)object).weight;
                    arrayList.add(object4);
                }
                object2 = this.makeModelGraph(graphics2D, arrayList);
                this.translateComponent((Component)object2, 0.0, 15.0);
                childManager2.insert(-1000000, (Component)object2);
                object4 = new Line2D.Double(0.0, 10.0, 0.0, 15.0);
                object3 = new Primative((Shape)object4);
                childManager2.insert(-2000000, (Component)object3);
            }
            double d = 5.0;
            this.translateComponent(component, n3, d);
            while (!this.fitsGraph(compositeRectangularBorder, component.getBounds2D())) {
                this.translateComponent(component, 0.0, 20.0);
                d += 20.0;
            }
            childManager.insert(-1000000, component);
            object2 = new Line2D.Double(n3, 0.0, n3, d);
            object4 = new Primative((Shape)object2);
            childManager.insert(-1000000, (Component)object4);
        }
        object = new Line2D.Double(n, 0.0, n2, 0.0);
        component = new Primative((Shape)object);
        childManager.insert(-1000000, component);
        return compositeRectangularBorder;
    }

    private boolean fitsGraph(Composite composite, Rectangle2D rectangle2D) {
        Iterator iterator = composite.getChildIterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            Shape shape = component.getAbsoluteBounds();
            if (!shape.intersects(rectangle2D)) continue;
            return false;
        }
        return true;
    }

    private void translateComponent(Component component, double d, double d2) {
        component.alterTransform().translate(d, d2);
    }

    private Shape drawDistribution(DiscreteDistribution discreteDistribution) {
        double d = 10.0;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)discreteDistribution.getMin() - 0.5f, 10.0f);
        int n = discreteDistribution.getMin();
        while (n <= discreteDistribution.getMax()) {
            float f = 10.0f - (float)(d * discreteDistribution.probabilityDivMax(n));
            generalPath.lineTo((float)n - 0.5f, f);
            generalPath.lineTo((float)n + 0.5f, f);
            generalPath.lineTo((float)n + 0.5f, 10.0f);
            ++n;
        }
        generalPath.lineTo((float)discreteDistribution.getMax() + 0.5f, 10.0f);
        generalPath.closePath();
        return generalPath;
    }

    private Shape directionArrow(double d) {
        double d2 = 1.0 - d;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(8.0f, 1.0f);
        generalPath.lineTo(8.0f, 1.0f + (float)d2 * 3.0f);
        generalPath.lineTo(8.0f + (float)d2 * 6.0f, 0.0f);
        generalPath.lineTo(8.0f, -(1.0f + (float)d2 * 3.0f));
        generalPath.lineTo(8.0f, -1.0f);
        generalPath.lineTo(-8.0f, -1.0f);
        generalPath.lineTo(-8.0f, -(1.0f + (float)d * 3.0f));
        generalPath.lineTo(-(8.0f + (float)d * 6.0f), 0.0f);
        generalPath.lineTo(-8.0f, 1.0f + (float)d * 3.0f);
        generalPath.lineTo(-8.0f, 1.0f);
        generalPath.closePath();
        return generalPath;
    }

    public String wmToMotif(WeightMatrix weightMatrix) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = 0;
            while (n < weightMatrix.columns()) {
                double d = 0.0;
                Symbol symbol = null;
                Distribution distribution = weightMatrix.getColumn(n);
                Iterator iterator = ((FiniteAlphabet)weightMatrix.getAlphabet()).iterator();
                while (iterator.hasNext()) {
                    Symbol symbol2 = (Symbol)iterator.next();
                    double d2 = distribution.getWeight(symbol2);
                    if (!(d2 > d)) continue;
                    d = d2;
                    symbol = symbol2;
                }
                stringBuffer.append(symbol.getToken());
                ++n;
            }
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
        return stringBuffer.toString();
    }

    public void wmViewer(WeightMatrix weightMatrix, String string) {
        Object object;
        Object object2;
        Object object3;
        try {
            int n = 0;
            while (n < weightMatrix.columns()) {
                System.out.println("Column: " + n);
                object3 = weightMatrix.getColumn(n);
                object2 = ((FiniteAlphabet)weightMatrix.getAlphabet()).iterator();
                while (object2.hasNext()) {
                    object = (Box[])object2.next();
                    System.out.println("" + object.getToken() + " : " + object3.getWeight((Symbol)object));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
        JFrame jFrame = new JFrame("Weight matrix viewer" + (string == null ? "" : " (" + string + ")"));
        try {
            if (weightMatrix.getColumn(0) instanceof OrderNDistribution) {
                Object object4;
                object3 = ModelTools.flattenHigherOrderWM(weightMatrix);
                object2 = (FiniteAlphabet)((OrderNDistribution)weightMatrix.getColumn(0)).getConditioningAlphabet();
                object = new Box[object2.size() + 1];
                int n = 0;
                ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    arrayList.add(symbol);
                    object[n] = Box.createHorizontalBox();
                    ((Container)object[n]).add(new JLabel(symbol.getName()));
                    ++n;
                }
                object[n] = Box.createHorizontalBox();
                object[n].add(new JLabel("1st Order"));
                int n2 = 0;
                while (n2 < weightMatrix.columns()) {
                    Object object5;
                    object4 = (OrderNDistribution)weightMatrix.getColumn(n2);
                    n = 0;
                    Iterator iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        object5 = (Symbol)iterator2.next();
                        Distribution distribution = object4.getDistribution((Symbol)object5);
                        DistributionLogo distributionLogo = new DistributionLogo();
                        distributionLogo.setDistribution(distribution);
                        distributionLogo.setPreferredSize(new Dimension(70, 100));
                        distributionLogo.setLogoPainter(new TextLogoPainter());
                        distributionLogo.setStyle(new DNAStyle());
                        ((Container)object[n++]).add(distributionLogo);
                    }
                    object5 = new DistributionLogo();
                    ((DistributionLogo)object5).setDistribution(object3.getColumn(n2));
                    ((JComponent)object5).setPreferredSize(new Dimension(70, 100));
                    ((DistributionLogo)object5).setLogoPainter(new TextLogoPainter());
                    ((DistributionLogo)object5).setStyle(new DNAStyle());
                    ((Container)object[n]).add((java.awt.Component)object5);
                    ++n2;
                }
                object4 = Box.createVerticalBox();
                n = 0;
                while (n < ((Object)object).length) {
                    ((Container)object4).add((java.awt.Component)object[n]);
                    ++n;
                }
                jFrame.getContentPane().add((java.awt.Component)object4);
            } else {
                jFrame.getContentPane().setLayout(new GridLayout(1, weightMatrix.columns()));
                int n = 0;
                while (n < weightMatrix.columns()) {
                    jFrame.getContentPane().setLayout(new GridLayout(1, weightMatrix.columns()));
                    object2 = weightMatrix.getColumn(n);
                    object = new DistributionLogo();
                    ((DistributionLogo)object).setDistribution((Distribution)object2);
                    ((JComponent)object).setPreferredSize(new Dimension(70, 100));
                    ((DistributionLogo)object).setLogoPainter(new TextLogoPainter());
                    ((DistributionLogo)object).setStyle(new DNAStyle());
                    jFrame.getContentPane().add((java.awt.Component)object);
                    ++n;
                }
            }
        }
        catch (BioException bioException) {
            throw new BioError(bioException);
        }
        jFrame.pack();
        ((java.awt.Component)jFrame).setVisible(true);
    }

    static /* synthetic */ Map access$200(ModelViewerSG modelViewerSG) {
        return modelViewerSG.componentToWeightMatrix;
    }

    static /* synthetic */ Map access$300(ModelViewerSG modelViewerSG) {
        return modelViewerSG.componentToRuleDescriptions;
    }

    private class ModelPanel
    extends JPanel
    implements Printable {
        GLMClassificationModel model;
        Component modelGraph;

        public ModelPanel(GLMClassificationModel gLMClassificationModel) {
            this.setPreferredSize(new Dimension(3200, 3000));
            this.model = gLMClassificationModel;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ModelPanel this$1;
                {
                    this.this$1 = modelPanel;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    double d = mouseEvent.getX() / 3 - 600;
                    double d2 = mouseEvent.getY() / 3 - 20;
                    Point2D.Double double_ = new Point2D.Double(d, d2);
                    List list = this.this$1.modelGraph.getObjectsAt(double_);
                    Iterator<E> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Component component = (Component)iterator.next();
                        WeightMatrix weightMatrix = (WeightMatrix)ModelViewerSG.access$200(ModelPanel.access$100(this.this$1)).get(component);
                        if (weightMatrix == null) continue;
                        ModelPanel.access$100(this.this$1).wmViewer(weightMatrix, (String)ModelViewerSG.access$300(ModelPanel.access$100(this.this$1)).get(component));
                        return;
                    }
                }
            });
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(-700, 200);
            graphics2D.scale(0.5, 0.5);
            this.rawPaint(graphics2D);
            return 0;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.rawPaint(graphics);
        }

        private void rawPaint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.addRenderingHints(hashMap);
            graphics2D.scale(3.0, 3.0);
            graphics2D.translate(600, 20);
            if (this.modelGraph == null) {
                this.modelGraph = ModelViewerSG.this.layoutPanel(graphics2D, this.model);
            }
            this.modelGraph.paint(graphics2D);
        }

        static /* synthetic */ ModelViewerSG access$100(ModelPanel modelPanel) {
            return modelPanel.ModelViewerSG.this;
        }
    }

    private static class PositionedConstraintWithWeight {
        public PositionedConstraint pc;
        public double weight;

        private PositionedConstraintWithWeight() {
        }
    }
}

