/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.Label;
import org.biojava.utils.bytecode.LabelInstruction;

public class IfExpression
implements CodeGenerator {
    private Instruction ifInstruction;
    private CodeGenerator ifTrue;
    private CodeGenerator ifFalse;
    private Label trueLabel = new Label();
    private Label endLabel = new Label();
    private Instruction skipTrue = ByteCode.make_goto(this.endLabel);

    public Instruction getIfInstruction() {
        return this.ifInstruction;
    }

    public CodeGenerator getIfTrue() {
        return this.ifTrue;
    }

    public CodeGenerator getIfFalse() {
        return this.ifFalse;
    }

    public void writeCode(CodeContext codeContext) throws CodeException {
        CodeContext codeContext2 = codeContext.subContext();
        codeContext2.open();
        this.ifInstruction.writeCode(codeContext2);
        this.ifFalse.writeCode(codeContext2);
        this.skipTrue.writeCode(codeContext2);
        codeContext2.markLabel(this.trueLabel);
        this.ifTrue.writeCode(codeContext2);
        codeContext2.markLabel(this.endLabel);
        codeContext2.close();
    }

    public IfExpression(byte by, CodeGenerator codeGenerator, CodeGenerator codeGenerator2) {
        this.ifInstruction = new LabelInstruction(by, this.trueLabel);
        this.ifTrue = codeGenerator;
        this.ifFalse = codeGenerator2;
    }
}

