### R code from vignette source 'OCplus.Rnw'

###################################################
### code chunk number 1: OCplus.Rnw:44-45
###################################################
options(width=65)


###################################################
### code chunk number 2: OCplus.Rnw:65-66
###################################################
library(OCplus)


###################################################
### code chunk number 3: OCplus.Rnw:74-75
###################################################
ss1 = samplesize(p0=0.95, D=1, crit=0.01)


###################################################
### code chunk number 4: OCplus.Rnw:78-79
###################################################
ss1


###################################################
### code chunk number 5: OCplus.Rnw:87-88
###################################################
samplesize(p0=0.95, D=1, crit=0.01)


###################################################
### code chunk number 6: OCplus.Rnw:100-101
###################################################
TOC(n=20, p0=0.95, D=1, alpha=FALSE, legend=TRUE)


###################################################
### code chunk number 7: OCplus.Rnw:112-116
###################################################
set.seed(123)
simdat = MAsim(ng=10000, n=10, p0=0.95, D=1, sigma=1)
dim(simdat)
colnames(simdat)


###################################################
### code chunk number 8: OCplus.Rnw:124-126
###################################################
sim1 = EOC(simdat, colnames(simdat))
sim1[1:5,]


###################################################
### code chunk number 9: OCplus.Rnw:131-132
###################################################
topDE(sim1, co=0.1)


###################################################
### code chunk number 10: OCplus.Rnw:136-137
###################################################
p0(sim1)


###################################################
### code chunk number 11: OCplus.Rnw:143-144
###################################################
plot(sim1)


###################################################
### code chunk number 12: OCplus.Rnw:153-155
###################################################
sim2 = fdr1d(simdat, colnames(simdat), verb=FALSE)
sim2[1:5,]


###################################################
### code chunk number 13: OCplus.Rnw:160-161
###################################################
summary(sim2)


###################################################
### code chunk number 14: OCplus.Rnw:166-167
###################################################
topDE(sim2, co=0.1)


###################################################
### code chunk number 15: OCplus.Rnw:172-173
###################################################
plot(sim2)


###################################################
### code chunk number 16: OCplus.Rnw:183-185
###################################################
sim3 = fdr2d(simdat, colnames(simdat), p0=p0(sim2), verb=FALSE)
sim3[1:5,]


###################################################
### code chunk number 17: OCplus.Rnw:193-195
###################################################
plot(sim2)
lines(average.fdr(sim3), lty=2)


###################################################
### code chunk number 18: OCplus.Rnw:202-204
###################################################
summary(sim3)
topDE(sim3, co=0.1)


###################################################
### code chunk number 19: OCplus.Rnw:211-212
###################################################
plot(sim3)


###################################################
### code chunk number 20: OCplus.Rnw:225-226
###################################################
OCshow(sim1, sim2, sim3, legend=c("FDR","fdr1d","fdr2d"))


###################################################
### code chunk number 21: OCplus.Rnw:236-239
###################################################
tt = tstatistics(simdat, colnames(simdat))
tt[1:10,] 
tm = tMixture(tt, nq=3)


###################################################
### code chunk number 22: OCplus.Rnw:242-243
###################################################
tm$p0.est


###################################################
### code chunk number 23: OCplus.Rnw:246-248
###################################################
tMixture(tt, nq=3, p0=0.80)$p0.est
tMixture(tt, nq=3, p0=0.60)$p0.est


###################################################
### code chunk number 24: OCplus.Rnw:253-256
###################################################
tm2 = tMixture(tt, nq=5)
tm2$p0.est
tm2$p0.raw


###################################################
### code chunk number 25: OCplus.Rnw:259-261
###################################################
tm2$p1
tm2$delta


