/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import edu.oswego.cs.dl.util.concurrent.Barrier;
import edu.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import edu.oswego.cs.dl.util.concurrent.TimeoutException;

public class CyclicBarrier
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected Runnable barrierCommand_ = null;
    protected int count_;
    protected int resets_ = 0;

    public CyclicBarrier(int n) {
        this(n, null);
    }

    public CyclicBarrier(int n, Runnable runnable) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = n;
        this.count_ = n;
        this.barrierCommand_ = runnable;
    }

    public int attemptBarrier(long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doBarrier(true, l);
    }

    public int barrier() throws InterruptedException, BrokenBarrierException {
        return this.doBarrier(false, 0L);
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    protected synchronized int doBarrier(boolean bl, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        int n = --this.count_;
        if (this.broken_) {
            throw new BrokenBarrierException(n);
        }
        if (Thread.interrupted()) {
            this.broken_ = true;
            this.notifyAll();
            throw new InterruptedException();
        }
        if (n == 0) {
            this.count_ = this.parties_;
            ++this.resets_;
            this.notifyAll();
            try {
                if (this.barrierCommand_ != null) {
                    this.barrierCommand_.run();
                }
                return 0;
            }
            catch (RuntimeException runtimeException) {
                this.broken_ = true;
                return 0;
            }
        }
        if (bl && l <= 0L) {
            this.broken_ = true;
            this.notifyAll();
            throw new TimeoutException(l);
        }
        int n2 = this.resets_;
        long l2 = bl ? System.currentTimeMillis() : 0L;
        long l3 = l;
        do {
            try {
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                if (this.resets_ == n2) {
                    this.broken_ = true;
                    this.notifyAll();
                    throw interruptedException;
                }
                Thread.currentThread().interrupt();
            }
            if (this.broken_) {
                throw new BrokenBarrierException(n);
            }
            if (n2 == this.resets_) continue;
            return n;
        } while (!bl || (l3 = l - (System.currentTimeMillis() - l2)) > 0L);
        this.broken_ = true;
        this.notifyAll();
        throw new TimeoutException(l);
    }

    public int parties() {
        return this.parties_;
    }

    public synchronized void restart() {
        this.broken_ = false;
        ++this.resets_;
        this.count_ = this.parties_;
        this.notifyAll();
    }

    public synchronized Runnable setBarrierCommand(Runnable runnable) {
        Runnable runnable2 = this.barrierCommand_;
        this.barrierCommand_ = runnable;
        return runnable2;
    }
}

