/*
 * Decompiled with CFR 0.152.
 */
package jal.BYTE;

import jal.BYTE.BinaryOperator;
import jal.BYTE.BinaryPredicate;
import jal.BYTE.Generator;
import jal.BYTE.Inspection;
import jal.BYTE.Predicate;
import jal.BYTE.UnaryOperator;
import java.util.Random;

public final class Modification {
    private static Random default_RNG = new Random();

    public static void copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (n2 > n) {
            System.arraycopy(byArray, n, byArray2, n3, n2 - n);
        }
    }

    public static void swap_ranges(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        while (n < n2) {
            byte by = byArray2[n3];
            byArray2[n3] = byArray[n];
            byArray[n] = by;
            ++n;
            ++n3;
        }
    }

    public static void transform(byte[] byArray, byte[] byArray2, int n, int n2, int n3, UnaryOperator unaryOperator) {
        while (n < n2) {
            byArray2[n3++] = unaryOperator.apply(byArray[n++]);
        }
    }

    public static void transform(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, BinaryOperator binaryOperator) {
        while (n < n2) {
            byArray3[n4++] = binaryOperator.apply(byArray[n++], byArray2[n3++]);
        }
    }

    public static void replace(byte[] byArray, int n, int n2, byte by, byte by2) {
        while (n < n2) {
            if (byArray[n] == by) {
                byArray[n] = by2;
            }
            ++n;
        }
    }

    public static void replace_if(byte[] byArray, int n, int n2, Predicate predicate, byte by) {
        while (n < n2) {
            if (predicate.apply(byArray[n])) {
                byArray[n] = by;
            }
            ++n;
        }
    }

    public static void replace_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3, byte by, byte by2) {
        while (n < n2) {
            byte by3 = byArray[n++];
            byte by4 = byArray2[n3++] = by3 == by ? by2 : by3;
        }
    }

    public static void replace_copy_if(byte[] byArray, byte[] byArray2, int n, int n2, int n3, Predicate predicate, byte by) {
        while (n < n2) {
            byte by2 = byArray[n++];
            byte by3 = byArray2[n3++] = predicate.apply(by2) ? by : by2;
        }
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        while (n < n2) {
            byArray[n++] = by;
        }
    }

    public static void generate(byte[] byArray, int n, int n2, Generator generator) {
        while (n < n2) {
            byArray[n++] = generator.apply();
        }
    }

    public static int remove_if(byte[] byArray, int n, int n2, byte by) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && byArray[n] != by) {
                continue;
            }
            while (n < --n2 && byArray[n2] == by) {
            }
            if (n >= n2) {
                return n;
            }
            byArray[n] = byArray[n2];
        }
    }

    public static int remove_if(byte[] byArray, int n, int n2, Predicate predicate) {
        int n3 = n2;
        --n;
        while (true) {
            if (++n < n2 && !predicate.apply(byArray[n])) {
                continue;
            }
            while (n < --n2 && predicate.apply(byArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            byArray[n] = byArray[n2];
        }
    }

    public static int stable_remove(byte[] byArray, int n, int n2, byte by) {
        n = Inspection.find(byArray, n, n2, by);
        int n3 = Inspection.find_not(byArray, n, n2, by);
        while (n3 < n2) {
            byArray[n++] = byArray[n3];
            ++n3;
            n3 = Inspection.find_not(byArray, n3, n2, by);
        }
        return n;
    }

    public static int stable_remove_if(byte[] byArray, int n, int n2, Predicate predicate) {
        n = Inspection.find_if(byArray, n, n2, predicate);
        int n3 = Inspection.find_if_not(byArray, n, n2, predicate);
        while (n3 < n2) {
            byArray[n++] = byArray[n3];
            ++n3;
            n3 = Inspection.find_if_not(byArray, n3, n2, predicate);
        }
        return n;
    }

    public static int remove_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3, byte by) {
        while (n < n2) {
            byte by2;
            if ((by2 = byArray[n++]) == by) continue;
            byArray2[n3++] = by2;
        }
        return n3;
    }

    public static int remove_copy_if(byte[] byArray, byte[] byArray2, int n, int n2, int n3, Predicate predicate) {
        while (n < n2) {
            byte by;
            if (predicate.apply(by = byArray[n++])) continue;
            byArray2[n3++] = by;
        }
        return n3;
    }

    public static int unique(byte[] byArray, int n, int n2) {
        n = Inspection.adjacent_find(byArray, n, n2);
        return Modification.unique_copy(byArray, byArray, n, n2, n);
    }

    public static int unique(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        n = Inspection.adjacent_find(byArray, n, n2, binaryPredicate);
        return Modification.unique_copy(byArray, byArray, n, n2, n, binaryPredicate);
    }

    public static int unique_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        if (n >= n2) {
            return n3;
        }
        byArray2[n3] = byArray[n];
        while (++n < n2) {
            if (byArray2[n3] == byArray[n]) continue;
            byArray2[++n3] = byArray[n];
        }
        return n3 + 1;
    }

    public static int unique_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n3;
        }
        byArray2[n3] = byArray[n];
        while (++n < n2) {
            if (binaryPredicate.apply(byArray2[n3], byArray[n])) continue;
            byArray2[++n3] = byArray[n];
        }
        return n3 + 1;
    }

    public static void reverse(byte[] byArray, int n, int n2) {
        while (n < --n2) {
            byte by = byArray[n];
            byArray[n++] = byArray[n2];
            byArray[n2] = by;
        }
    }

    public static void reverse_copy(byte[] byArray, int n, int n2, int n3) {
        while (n2 > n) {
            byArray[n3++] = byArray[--n2];
        }
    }

    public static void reverse_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        while (n2 > n) {
            byArray2[n3++] = byArray[--n2];
        }
    }

    public static void rotate(byte[] byArray, int n, int n2, int n3) {
        if (n2 != n && n2 != n3) {
            Modification.reverse(byArray, n, n2);
            Modification.reverse(byArray, n2, n3);
            Modification.reverse(byArray, n, n3);
        }
    }

    public static void rotate_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        Modification.copy(byArray, byArray2, n2, n3, n4);
        Modification.copy(byArray, byArray2, n, n2, n4 + (n3 - n2));
    }

    public static void random_shuffle(byte[] byArray, int n, int n2, Random random) {
        int n3 = n + 1;
        while (n3 < n2) {
            int n4 = Math.abs(random.nextInt()) % (n3 - n + 1);
            byte by = byArray[n4];
            byArray[n4] = byArray[n3];
            byArray[n3] = by;
            ++n3;
        }
    }

    public static void random_shuffle(byte[] byArray, int n, int n2) {
        Modification.random_shuffle(byArray, n, n2, default_RNG);
    }

    public static int partition(byte[] byArray, int n, int n2, Predicate predicate) {
        --n;
        while (true) {
            if (++n < n2 && predicate.apply(byArray[n])) {
                continue;
            }
            while (n < --n2 && !predicate.apply(byArray[n2])) {
            }
            if (n >= n2) {
                return n;
            }
            byte by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
        }
    }

    public static int stable_partition(byte[] byArray, int n, int n2, Predicate predicate) {
        if (n + 1 < n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = Modification.stable_partition(byArray, n, n3, predicate);
            int n5 = Modification.stable_partition(byArray, n3, n2, predicate);
            Modification.rotate(byArray, n4, n3, n5);
            return n4 + (n5 - n3);
        }
        if (n >= n2 || !predicate.apply(byArray[n])) {
            return n;
        }
        return n2;
    }

    private Modification() {
    }
}

