% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ReplaceOutliersByMAD}
\alias{ReplaceOutliersByMAD}
\title{Replacing outliers by moderated MAD}
\usage{
ReplaceOutliersByMAD(object, replaceOutlier = TRUE, cutoff = 2,
  baseMean = 100, limitMad = 0.707, spriors = 2, Caseon = TRUE, ...)
}
\arguments{
\item{object}{a ABSSeq object with element of 'counts' and 'normMethod', see the constructor functions
\code{\link{ABSDataSet}}.}

\item{replaceOutlier}{switch for replacing, default is TRUE.}

\item{cutoff}{cutoff of moderating MAD for outliers, default is 2}

\item{baseMean}{parameter for limiting the trimming at low expression level by baseMean/(sample size), default is 100.}

\item{limitMad}{the minimal prior for moderating MAD, default is set to 0.707, which is usually the highest standard deviation at expression level of 1}

\item{spriors}{prior weight size for prior MAD, default is 2}

\item{Caseon}{switch for dealing with outlier trimming at sample size of 2}

\item{...}{reserved parameters}
}
\value{
a ABSDataSet object with normalized counts after trimming (replaceOutlier=TRUE) or not (replaceOutlier=FALSE). Use the \code{\link{excounts}}
to show it. Use \code{\link{results}} with name 'trimmed' to view the trimming status.
}
\description{
Function for replacing the outliers by MAD
}
\details{
Given a matrix of count data, this function replacing the outliers by MAD. Noticely, this function also provides part of parameters for DEs calling.
It is called by \code{\link{callParameter}}
}
\examples{

data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- normalFactors(obj)
obj <- ReplaceOutliersByMAD(obj)
head(excounts(obj))
head(results(obj,c("trimmed")))

}
