% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkFunctions.R
\name{ImputeNetParallel}
\alias{ImputeNetParallel}
\title{Network-based parallel imputation}
\usage{
ImputeNetParallel(drop.mat, arranged, cores =
BiocParallel::bpworkers(BPPARAM), type = 'iteration', max.iter = 50,
BPPARAM = BiocParallel::SnowParam(type = "SOCK"))
#'
}
\arguments{
\item{drop.mat}{matrix, logical; dropout entries in the data matrix
(genes as rows and samples as columns)}

\item{arranged}{list; output of \code{\link{ArrangeData}}}

\item{cores}{integer; number of cores used for paralell computation}

\item{type}{character; either 'iteration', for an iterative solution, or
'pseudoinv', to use Moore-Penrose pseudo-inversion as a solution.}

\item{max.iter}{numeric; maximum number of iterations for network
imputation. Set to -1 to remove limit (not recommended)}

\item{BPPARAM}{parallel back-end to be used during parallel computation.
See \code{\link[BiocParallel]{BiocParallelParam-class}}.}
}
\value{
matrix; imputation results incorporating network information
}
\description{
\code{ImputeNetParallel} implements network-based imputation
in parallel
}
