% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalize.R
\name{NormalizeTPM}
\alias{NormalizeTPM}
\title{TPM normalization}
\usage{
NormalizeTPM(data, sce = NULL, tr_length = NULL, log = FALSE,
scale = 1, pseudo.count = 1)
}
\arguments{
\item{data}{matrix; raw data (genes as rows and samples as columns)}

\item{sce}{SingleCellExperiment; raw data}

\item{tr_length}{data.frame with at least 2 columns: 'hgnc_symbol'
and 'transcript_length'}

\item{log}{logical; log TPMs?}

\item{scale}{integer; scale factor to divide TPMs by}

\item{pseudo.count}{numeric; if \code{log = T}, value to add to TPMs in order
to avoid taking \code{log(0)}}
}
\value{
matrix; normalized data (for transcript length and library size)
}
\description{
\code{NormalizeTPM} performs TPM normalization, with possibility
to log the result
}
\details{
Gene length is estimated as the median of the lengths of all
transcripts for each gene, as obtained from biomaRt.
Genes for which length information cannot be found in biomaRt are dropped.
}
\examples{
demo <- NormalizeTPM(ADImpute::demo_data)

}
