% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_methods.R
\name{as.list,cacomp-method}
\alias{as.list,cacomp-method}
\title{Convert cacomp object to list.}
\usage{
\S4method{as.list}{cacomp}(x)
}
\arguments{
\item{x}{A cacomp object.}
}
\value{
A cacomp object.
}
\description{
Convert cacomp object to list.
}
\examples{

# Simulate counts
cnts <- mapply(function(x){rpois(n = 500, lambda = x)},
               x = sample(1:100, 50, replace = TRUE))
rownames(cnts) <- paste0("gene_", 1:nrow(cnts))
colnames(cnts) <- paste0("cell_", 1:ncol(cnts))

# Run correspondence analysis
ca <- cacomp(obj = cnts, princ_coords = 3)
ca_list <- as.list(ca)
}
