% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_on_quantification.R
\name{kruskalWallis}
\alias{kruskalWallis}
\title{Kruskal-Wallis rank sum tests on a \code{\link{SummarizedExperiment}} object}
\usage{
kruskalWallis(
  analysis_data,
  condition,
  alpha = 0.05,
  type.data = "quantifications",
  ...
)
}
\arguments{
\item{analysis_data}{A \code{\link{SummarizedExperiment}} object obtained
with the \code{\link{formatForAnalysis}} function.}

\item{condition}{The name of the design variable (two level factor)
specifying the group of each sample.}

\item{alpha}{Cutoff for adjusted p-values. Default to 0.05.}

\item{type.data}{Type of data used for the analyses (\emph{e.g.,}}

\item{...}{Arguments to be passed to \code{\link{p.adjust}} such as the
correction method to use with the \code{method} argument.
\code{"quantifications"}, \code{"buckets"}...). Default to
\code{"quantifications"}.}
}
\value{
A S4 object of class \linkS4class{AnalysisResults} containing test
results.
}
\description{
Perform Kruskal-Wallis tests on a \code{\link{SummarizedExperiment}} object
obtained with the \code{\link{formatForAnalysis}} function
}
\examples{
# Import quantification results
if (require("ASICSdata", quietly = TRUE)) {
  quantif_path <- system.file("extdata", "results_ASICS.txt",
                              package = "ASICSdata")
  quantification <- read.table(quantif_path, header = TRUE, row.names = 1)

  # Import design
  design <- read.table(system.file("extdata", "design_diabete_example.txt",
                                   package = "ASICSdata"), header = TRUE)
  design$condition <- factor(design$condition)

  # Create object for analysis and remove features with more than 25\% of
  # zeros
  analysis_obj <- formatForAnalysis(quantification,
                                    zero.threshold = 25, design = design)
  res_tests <- kruskalWallis(analysis_obj, "condition", method = "BH")
}

}
\seealso{
\linkS4class{AnalysisResults}
}
