% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_buildRankings.R
\name{AUCell_buildRankings}
\alias{AUCell_buildRankings}
\alias{AUCell_buildRankings,dgCMatrix-method}
\alias{AUCell_buildRankings,matrix-method}
\alias{AUCell_buildRankings,ExpressionSet-method}
\alias{AUCell_buildRankings,SummarizedExperiment-method}
\title{Build gene expression rankings for each cell}
\usage{
AUCell_buildRankings(
  exprMat,
  featureType = "genes",
  plotStats = TRUE,
  splitByBlocks = FALSE,
  BPPARAM = NULL,
  keepZeroesAsNA = FALSE,
  verbose = TRUE,
  nCores = NULL,
  mctype = NULL,
  ...
)

\S4method{AUCell_buildRankings}{dgCMatrix}(
  exprMat,
  featureType = "genes",
  plotStats = TRUE,
  splitByBlocks = TRUE,
  BPPARAM = NULL,
  keepZeroesAsNA = FALSE,
  verbose = TRUE,
  nCores = NULL,
  mctype = NULL
)

\S4method{AUCell_buildRankings}{matrix}(
  exprMat,
  featureType = "genes",
  plotStats = TRUE,
  splitByBlocks = FALSE,
  BPPARAM = NULL,
  keepZeroesAsNA = FALSE,
  verbose = TRUE,
  nCores = NULL,
  mctype = NULL
)

\S4method{AUCell_buildRankings}{ExpressionSet}(
  exprMat,
  featureType = "genes",
  plotStats = TRUE,
  splitByBlocks = FALSE,
  BPPARAM = NULL,
  keepZeroesAsNA = FALSE,
  verbose = TRUE,
  nCores = NULL,
  mctype = NULL
)

\S4method{AUCell_buildRankings}{SummarizedExperiment}(
  exprMat,
  featureType = "genes",
  plotStats = TRUE,
  splitByBlocks = FALSE,
  BPPARAM = NULL,
  keepZeroesAsNA = FALSE,
  verbose = TRUE,
  assayName = NULL,
  nCores = NULL,
  mctype = NULL
)
}
\arguments{
\item{exprMat}{Expression matrix (genes as rows, cells as columns)
The expression matrix can also be provided as one of the R/Bioconductor classes:
\itemize{
\item \link[Matrix]{dgCMatrix-class}:
Sparse matrix 
\item \link{RangedSummarizedExperiment} and derived classes (e.g. \link[SingleCellExperiment]{SingleCellExperiment} ):
The matrix will be obtained through assay(exprMatrix),
-which will extract the first assay (usually the counts)-
or the assay name given in 'assayName'
\item \code{ExpressionSet}:
The matrix will be obtained through exprs(exprMatrix)
}}

\item{featureType}{Name for the rows (e.g. "genes"). Only for naming the rankings, not used internally.}

\item{plotStats}{Should the function plot the expression boxplots/histograms?
(TRUE / FALSE). These plots can also be produced
with the function \code{\link{plotGeneCount}}.}

\item{splitByBlocks}{Whether to split the matrix by blocks in the ranking calculation. 
Allows using multiple cores.
FALSE by default. If using sparse matrices it is automatically set to TRUE.}

\item{BPPARAM}{Set to use multiple cores. Only used if 'splitByBlocks=TRUE'}

\item{keepZeroesAsNA}{Convert zeroes to NA instead of locating randomly at the end of the ranking.}

\item{verbose}{Should the function show progress messages? (TRUE / FALSE)}

\item{nCores}{Deprecated}

\item{mctype}{Deprecated}

\item{...}{Other arguments}

\item{assayName}{Name of the assay containing the expression matrix (e.g. in \link[SingleCellExperiment]{SingleCellExperiment} objects)}
}
\value{
Ranking of the feature within the cell (features as rows, cells as columns)
}
\description{
Builds the "rankings" for each cell:
expression-based ranking for all the genes in each cell.

The genes with same expression value are shuffled.
Therefore, genes with expression '0' are randomly sorted at the
end of the ranking.

These "rankings" can be seen as a new representation of the original dataset.
Once they are calculated, they can be saved for future analyses.
}
\details{
It is important to check that most cells have at least the number of
expressed/detected genes that are going to be used to calculate the AUC
(`aucMaxRank` in `calcAUC()`).
The histogram provided by `AUCell_buildRankings()`
allows to quickly check this distribution.
`plotGeneCount(exprMatrix)` allows to obtain only the plot before
building the rankings.
}
\examples{
# This example is run using a fake expression matrix.
# Therefore, the output will be meaningless.

############# Fake expression matrix #############
set.seed(123)
exprMatrix <- matrix(data=sample(c(rep(0, 5000), sample(1:3, 5000, replace=TRUE))),
                     nrow=20, 
                     dimnames=list(paste("Gene", 1:20, sep=""), 
                                   paste("Cell", 1:500, sep="")))
##################################################

cells_rankings <- AUCell_buildRankings(exprMatrix, plotStats=TRUE)
cells_rankings
}
\seealso{
Next step in the workflow: \code{\link{AUCell_calcAUC}}.

See the package vignette for examples and more details:
\code{vignette("AUCell")}
}
