% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAAspectra.R
\name{getSipBYionSpectra}
\alias{getSipBYionSpectra}
\title{Get AAspectra object of B and Y ions from AA sequence
with labeled SIP abundance}
\usage{
getSipBYionSpectra(
  AAstr,
  Atom = "C13",
  Prob = 0.0107,
  charges = 1,
  precursorCharges = 2
)
}
\arguments{
\item{AAstr}{Amino acide string}

\item{Atom}{"C13" or "N15". Default is "C13"}

\item{Prob}{C13 or N15's abundance. Default is 0.0107}

\item{charges}{NumericVector of product ion's charge. Default is 1:2}

\item{precursorCharges}{NumericVector of precursor's charge. Default is 2}
}
\value{
AAspectra object
}
\description{
Get AAspectra object of B and Y ions from AA sequence
with labeled SIP abundance
}
\examples{
# add precursor
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.05, 1:2, 2)
tail(slot(a, "spectra"))
# not add precursor
a <- getSipBYionSpectra("KHRIPCDRK", "C13", 0.05, 1:2, 0)
tail(slot(a, "spectra"))
}
