% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAAspectra.R
\name{plot,AAspectra,missing-method}
\alias{plot,AAspectra,missing-method}
\alias{plot,AAspectra-method}
\title{Plot an AAspectra object}
\usage{
\S4method{plot}{AAspectra,missing}(x, y, linewidth = 0.1, ...)
}
\arguments{
\item{x}{AAspectra object.}

\item{y}{(ignored, must be missing)}

\item{linewidth}{Numeric width of MS peaks. Default 0.1.}

\item{...}{Passed on (currently unused).}
}
\value{
A ggplot2 object.
}
\description{
S4 plot method producing a ggplot2 spectrum for an AAspectra object.
}
\examples{
a <- getPrecursorSpectra("KHRIP", 2)
plot(a) +
    ggplot2::scale_x_continuous(breaks = seq(324, 329, by = 0.5)) +
    ggplot2::geom_linerange(linewidth = 0.2)
}
\seealso{
AAspectra
}
