% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProteinSipPct.R
\name{plotPSMsipPCT}
\alias{plotPSMsipPCT}
\title{Plot the distribution of SIP percent for PSMs}
\usage{
plotPSMsipPCT(psmPath)
}
\arguments{
\item{psmPath}{A character string specifying the path to the PSM file.}
}
\value{
A ggplot2 object representing the histogram of SIP percent values.
}
\description{
This function reads a PSM file, processes the SIP percent values,
and generates a histogram with a dashed vertical line indicating the median.
}
\examples{
demo_file <- system.file("extdata", "demo.psm.txt", package = "Aerith")
p <- plotPSMsipPCT(demo_file)
p
}
