% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScanFrequency.R
\name{plotScanFrequency}
\alias{plotScanFrequency}
\title{Plot scan frequency}
\usage{
plotScanFrequency(info, binwidth = 1, breaks = seq(0, 200, by = 10))
}
\arguments{
\item{info}{A data.frame of retention time and precursor mass}

\item{binwidth}{A numeric value of bin width. Default is 1}

\item{breaks}{A numeric vector of breaks for x axis. Default is seq(0, 200, by = 10)}
}
\value{
A ggplot of scan frequency per minute
}
\description{
Plot scan frequency
}
\examples{
demo_file <- system.file("extdata", "demo.FT2", package = "Aerith")
a <- readAllScanMS2(demo_file)
b <- getRetentionTimeAndPrecursorInfo(a)
plotScanFrequency(b, binwidth = 0.1, breaks = seq(9, 10, by = 0.2))
rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
demo_file <- tempfile(fileext = ".FT1")
writeLines(readRDS(rds), demo_file)
a <- readAllScanMS1(demo_file)
b <- getRetentionTimeAndPrecursorInfo(a)
plotScanFrequency(b, binwidth = 0.1, breaks = seq(9, 10, by = 0.2))
}
