% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{readScansMS1}
\alias{readScansMS1}
\title{read MS1 scans with scanNumber as index in a range}
\usage{
readScansMS1(ftFile, startScanNumber, endScanNumber)
}
\arguments{
\item{ftFile}{a ft1 file's full path}

\item{startScanNumber}{read scans starting from this scanNumber}

\item{endScanNumber}{read scans ending at this scanNumber}
}
\value{
a list of MS1 scans with names of scan number
}
\description{
read MS1 scans with scanNumber as index in a range
}
\examples{
rds <- system.file("extdata", "demo.FT1.rds", package = "Aerith")
demo_file <- tempfile(fileext = ".FT1")
writeLines(readRDS(rds), demo_file)
ft1 <- readScansMS1(demo_file, 1398, 1503)
}
