% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{readSpe2PepFilesScansTopPSMsFromEachFT2Parallel}
\alias{readSpe2PepFilesScansTopPSMsFromEachFT2Parallel}
\title{readSpe2PepFilesScansTopPSMsFromEachFT2Parallel read each scan's top PSMs from multiple .Spe2PepFile.txt files of each .FT2 file}
\usage{
readSpe2PepFilesScansTopPSMsFromEachFT2Parallel(workingPath, topN = 5L)
}
\arguments{
\item{workingPath}{a full path with .Spe2PepFile.txt files in it}

\item{topN}{store top N PSMs of each scan of one .FT2 file}
}
\value{
a dataframe of top N PSMs
}
\description{
readSpe2PepFilesScansTopPSMsFromEachFT2Parallel read each scan's top PSMs from multiple .Spe2PepFile.txt files of each .FT2 file
}
\examples{
tmp <- tempdir()
sip_dir <- file.path(tmp, "sip")
dir.create(sip_dir)
demo_file <- system.file("extdata", "demo_target.Spe2Pep.txt", package = "Aerith")
file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000target.Spe2Pep.txt"))
demo_file <- system.file("extdata", "demo_decoy.Spe2Pep.txt", package = "Aerith")
file.copy(demo_file, file.path(sip_dir, "Pan_052322_X13.SIP_C13_050_000decoy.Spe2Pep.txt"))
list.files(sip_dir, full.names = TRUE)
top3 <-  readSpe2PepFilesScansTopPSMsFromEachFT2Parallel(sip_dir, 3)
}
