% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffiXcan.R
\name{affiXcanPcs}
\alias{affiXcanPcs}
\title{Compute PCs in MultiAssayExperiment objects using eigenvectors given by user}
\usage{
affiXcanPcs(
  tbaPaths,
  affiXcanTraining,
  scale,
  BPPARAM = bpparam(),
  testingSamples = NULL
)
}
\arguments{
\item{tbaPaths}{A vector of strings, which are the paths to
MultiAssayExperiment RDS files containing the tba values}

\item{affiXcanTraining}{The returning object from affiXcanTrain()}

\item{scale}{A logical; if scale=FALSE the TBA values will be only centered,
not scaled before performing PCA}

\item{BPPARAM}{A BiocParallelParam object. Default is bpparam(). For
details on BiocParallelParam virtual base class see 
browseVignettes("BiocParallel")}

\item{testingSamples}{A vector of strings. The identifiers (e.g. row names
of MultiAssayExperiment objects from tbaPaths) of the samples that have not
been considered in the training phase, to be used in the cross-validation;
default is NULL; if is.null(testingSamples)==TRUE then no filtering is
performed}
}
\value{
A list of matrices containing the principal components values of TBA
for each region; each object of the list is named after the
MultiAssayExperiment object from which it derives
}
\description{
Compute PCs in MultiAssayExperiment objects using eigenvectors given by user
}
\examples{
if (interactive()) {
data(exprMatrix)
data(trainingCovariates)
data(regionAssoc)

trainingTbaPaths <- system.file("extdata","training.tba.toydata.rds",
package="AffiXcan")
testingTbaPaths <- system.file("extdata","testing.tba.toydata.rds",
package="AffiXcan")

assay <- "values"

training <- affiXcanTrain(exprMatrix=exprMatrix, assay=assay,
tbaPaths=trainingTbaPaths, regionAssoc=regionAssoc, cov=trainingCovariates,
varExplained=80, scale=TRUE)

pcs <- affiXcanPcs(tbaPaths=testingTbaPaths, affiXcanTraining=training,
scale=TRUE)
}
}
