% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffiXcan.R
\name{computeCorrelation}
\alias{computeCorrelation}
\title{Compute R and R^2 on a particular row of two SummarizedExperiment assays}
\usage{
computeCorrelation(geneName, realExpr, imputedExpr)
}
\arguments{
\item{geneName}{A string. The row name in realExpr and imputedExpr objects
that identifies the vectors between which R and R^2 have to be computed}

\item{realExpr}{A SummarizedExperiment object containing expression data}

\item{imputedExpr}{The returning object of affiXcanImpute()}
}
\value{
A list of two objects:
\itemize{     
 \item rho: the pearson's correlation coefficient (R) between the real
 expression values and the imputed GReX for the cross-validation i on
 the expressed gene y, computed with cor()
 \item rho.sq: the coefficient of determination (R^2) between the real
 expression values and the imputed GReX for the cross-validation i on
 the expressed gene y, computed as pearson^2
 \item cor.test.p.val: the p-value of the cor.test() between the real expression values
 and the imputed GReX for the cross-validation i on the expressed gene y
}
}
\description{
Compute R and R^2 on a particular row of two SummarizedExperiment assays
}
\examples{
if (interactive()) {
trainingTbaPaths <- system.file("extdata","training.tba.toydata.rds",
package="AffiXcan")

data(exprMatrix)
data(regionAssoc)
data(trainingCovariates)

assay <- "values"

training <- affiXcanTrain(exprMatrix=exprMatrix, assay=assay,
tbaPaths=trainingTbaPaths, regionAssoc=regionAssoc, cov=trainingCovariates,
varExplained=80, scale=TRUE)

imputedExpr <- affiXcanImpute(tbaPaths=trainingTbaPaths,
affiXcanTraining=training, scale=TRUE)
realExpr <- exprMatrix

geneName <- "ENSG00000256377.1"
imputedExpr <- SummarizedExperiment::assays(imputedExpr)$GReX
realExpr <- SummarizedExperiment::assays(realExpr)[[assay]]

correlation <- computeCorrelation(geneName, realExpr, imputedExpr) 
}
}
