% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{getAreaFromGeneNames}
\alias{getAreaFromGeneNames}
\alias{getAreaFromGeneNames,character-method}
\title{Get Gene Area}
\usage{
getAreaFromGeneNames(genesymbols, ...)

\S4method{getAreaFromGeneNames}{character}(
  genesymbols,
  OrgDb,
  leftFlank = 0,
  rightFlank = 0,
  na.rm = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{genesymbols}{A character vector that contains genesymbols of genes
from which we wish to retrieve the coordinates}

\item{...}{arguments to pass on}

\item{OrgDb}{An \code{OrgDb} object containing gene annotation}

\item{leftFlank}{A \code{integer} specifying number of additional
nucleotides before the genes}

\item{rightFlank}{A \code{integer} specifying number of additional
nucleotides after the genes}

\item{na.rm}{A \code{boolean} removing genes that returned NA from the
annotation}

\item{verbose}{Setting \code{verbose=TRUE} makes function more talkative}
}
\value{
\code{getAreaFromGeneNames} returns a GRanges object with genomic
coordinates around the specified genes
}
\description{
Given a character vector with genesymbols and an OrgDb object, this function
returns a GRanges giving the coordinates of the genes.
}
\details{
This function is a convenience function that can be used to determine which
genomic coordinates to specify to e.g. \code{impBamGAL} when retrieving
reads.

The function cannot handle genes that do not exist in the annotation. To
remove these please set the na.rm=TRUE.
}
\examples{

#load example data
data(ASEset)

#get counts at the three positions specified in GRvariants
library(org.Hs.eg.db )
searchArea<-getAreaFromGeneNames(c('PAX8','TLR7'), org.Hs.eg.db)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{genes}
\keyword{locations}
