% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-methods.R
\docType{methods}
\name{regionSummary}
\alias{regionSummary}
\alias{regionSummary,numeric-method}
\alias{regionSummary,ASEset-method}
\title{regionSummary}
\usage{
regionSummary(x, ...)

\S4method{regionSummary}{ASEset}(x, region, strand = "*", return.class = "RegionSummary", ...)
}
\arguments{
\item{x}{ASEset object}

\item{...}{arguments to forward to internal functions}

\item{region}{to summmarize over, the object can be a GRanges, GRangesList}

\item{strand}{can be "+", "-" or "*"}

\item{return.class}{"array" or "list".}
}
\description{
Gives a summary of AI-consistency for a transcript
}
\details{
From a given set of e.g. transcripts exon ranges the function will return
a summary for the sum of all exons. Phase information, reference and alternative
allele is required.

A limitation comes to the strand-specificness. At the moment it is not possible
to call over more than one strand type using the strands in region. This will be
improved before going to release.

to calculate the direction and binomial p-values of AI the mapbias stored in the
ASEset is used. see '?mapBias'.
}
\examples{

data(ASEset)
a <- ASEset
# Add phase
set.seed(1)
p1 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p2 <- matrix(sample(c(1,0),replace=TRUE, size=nrow(a)*ncol(a)),nrow=nrow(a), ncol(a))
p <- matrix(paste(p1,sample(c("|","|","/"), size=nrow(a)*ncol(a), replace=TRUE), p2, sep=""),
	nrow=nrow(a), ncol(a))

phase(a) <- p

#add alternative allele information
mcols(a)[["alt"]] <- inferAltAllele(a)

# in this example each and all snps in the ASEset defines the region
region <- granges(a)
t <- regionSummary(a, region)

# in this example two overlapping subsets of snps in the ASEset defines the region
region <- split(granges(a)[c(1,2,2,3)],c(1,1,2,2))
t <- regionSummary(a, region)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{summary}
