% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_load_save.R
\name{load_and_save_functions}
\alias{load_and_save_functions}
\alias{nmr_dataset_load}
\alias{nmr_dataset_save}
\title{nmr_dataset_load}
\usage{
nmr_dataset_load(file_name)

nmr_dataset_save(nmr_dataset, file_name, ...)
}
\arguments{
\item{file_name}{The file name to load or save to}

\item{nmr_dataset}{An object from the \link{nmr_dataset_family}}

\item{...}{Additional arguments passed to \link{saveRDS}.}
}
\value{
Functions to load and save nmr_dataset objects

load nmr dataset

save nmr dataset
}
\description{
nmr_dataset_load

nmr_dataset_save
}
\examples{
# dataset <- nmr_dataset_load("test")
nmr_dataset <- nmr_dataset_load(system.file("extdata", "nmr_dataset.rds", package = "AlpsNMR"))

dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
# nmr_dataset_save(dataset, "test")

}
\seealso{
Other import/export functions: 
\code{\link{Pipelines}},
\code{\link{files_to_rDolphin}()},
\code{\link{nmr_data}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_read_bruker_fid}()},
\code{\link{nmr_read_samples}()},
\code{\link{nmr_zip_bruker_samples}()},
\code{\link{save_files_to_rDolphin}()},
\code{\link{save_profiling_output}()},
\code{\link{to_ChemoSpec}()}
}
\concept{import/export functions}
