% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_autophase.R
\name{nmr_autophase}
\alias{nmr_autophase}
\title{Rephase 1D NMR data}
\usage{
nmr_autophase(
  dataset,
  method = c("NLS", "MPC_DANM", "MPC_EMP", "SPC_DANM", "SPC_EMP", "SPC_AAM", "SPC_DSM"),
  withBC = FALSE,
  ...
)
}
\arguments{
\item{dataset}{An \link{nmr_dataset} object}

\item{method}{The autophasing method. See \code{\link[NMRphasing:NMRphasing]{NMRphasing::NMRphasing()}} for details.}

\item{withBC}{\code{NMRphasing::NMRphasing} may perform a baseline correction using modified polynomial fitting. By default
AlpsNMR offers other baseline estimation methods and better visualization of its effect, so AlpsNMR by default
disables the baseline correction offered by NMRphasing.}

\item{...}{Other parameters passed on to \code{\link[NMRphasing:NMRphasing]{NMRphasing::NMRphasing()}}.}
}
\value{
A (hopefully better phased) \link{nmr_dataset} object, with updated real and imaginary parts.
}
\description{
Use phasing algorithms to rephase data in the spectral domain.

This function may improve autophasing processing from instrument vendors. It
wraps the \code{\link[NMRphasing:NMRphasing]{NMRphasing::NMRphasing()}} function, to automatically rephase spectra,
allowing you to choose from a number of algorithms
of which \code{NLS}, \code{MPC_DANM} and \code{SPC_DANM} are the most recent.

Rephasing should happen before any spectra interpolation.

Please use the \code{all_components = TRUE} when calling \code{\link[=nmr_read_samples]{nmr_read_samples()}} in order
to load the complex spectra and fix NMR phasing correctly.
}
\examples{
if (requireNamespace("NMRphasing", quietly=TRUE)) {
  # Helpers to create a dataset:
  lorentzian <- function(x, x0, gamma, A) {
    A * (1 / (pi * gamma)) * ((gamma^2) / ((x - x0)^2 + gamma^2))
  }
  x <- seq(from=1, to=2, length.out = 300)
  y <- lorentzian(x, 1.3, 0.01, 1) + lorentzian(x, 1.6, 0.01, 1)
  dataset <- new_nmr_dataset(
    metadata = list(external = data.frame(NMRExperiment = "10")),
    data_fields = list(data_1r = list(y)),
    axis = list(list(x))
  )
  # Autophase, interpolate and plot:
  dataset <- nmr_autophase(dataset, method = "NLS")
  dataset <- nmr_interpolate_1D(dataset, axis = c(min = 1, max = 2, by = 0.01))
  plot(dataset)
}
}
