% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_1D.R
\name{nmr_data_1r_to_SummarizedExperiment}
\alias{nmr_data_1r_to_SummarizedExperiment}
\title{Export 1D NMR data to SummarizedExperiment}
\usage{
nmr_data_1r_to_SummarizedExperiment(nmr_dataset)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D} object}
}
\value{
SummarizedExperiment An SummarizedExperiment object (unmodified)
}
\description{
Export 1D NMR data to SummarizedExperiment
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
se <- nmr_data_1r_to_SummarizedExperiment(dataset_1D)
}
