% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset.R
\name{nmr_dataset}
\alias{nmr_dataset}
\title{nmr_dataset (S3 class)}
\description{
An \code{nmr_dataset} represents a set of NMR samples.
It is defined as an S3 class, and it can be treated as a regular list.
}
\details{
It currently has the following elements:
\itemize{
\item \code{metadata}: A list of data frames. Each data frame contains metadata of
a given area (acquisition parameters, preprocessing parameters, general sample information...)
\item \code{axis}: A list with length equal to the dimensionality of the data.
For 1D spectra it is a list with a numeric vector
\item \verb{data_*}: Data arrays with the actual spectra. The first index represents
the sample, the rest of the indices match the length of each \code{axis}.
Typically \code{data_1r} is a matrix with one sample on each row and the chemical
shifts in the columns.
\item \code{num_samples}: The number of samples in the dataset
}
}
\examples{
metadata_1D <- list(external = data.frame(NMRExperiment = c("10", "20")))
# Sample 10 and Sample 20 can have different lengths (due to different setups)
data_fields_1D <- list(data_1r = list(runif(16), runif(32)))
# Each sample has its own axis list, with one element (because this example is 1D)
axis_1D <- list(list(1:16), list(1:32))
my_1D_data <- new_nmr_dataset(metadata_1D, data_fields_1D, axis_1D)
}
\seealso{
\link[=load_and_save_functions]{Functions to save and load these objects}

Other AlpsNMR dataset objects: 
\code{\link{nmr_dataset_family}}
}
\concept{AlpsNMR dataset objects}
