% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_peak_table.R
\name{nmr_dataset_peak_table_to_SummarizedExperiment}
\alias{nmr_dataset_peak_table_to_SummarizedExperiment}
\title{Export nmr_dataset_peak_table to SummarizedExperiment}
\usage{
nmr_dataset_peak_table_to_SummarizedExperiment(nmr_peak_table)
}
\arguments{
\item{nmr_peak_table}{An \link{nmr_dataset_peak_table} object}
}
\value{
SummarizedExperiment object (unmodified)
}
\description{
Export nmr_dataset_peak_table to SummarizedExperiment
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
meta <- file.path(dir_to_demo_dataset, "dummy_metadata.xlsx")
metadata <- readxl::read_excel(meta, sheet = 1)
dataset_1D <- nmr_meta_add(dataset_1D, metadata = metadata, by = "NMRExperiment")
metadata <- list(external = dataset_1D[["metadata"]][["external"]])
peak_table <- nmr_data(dataset_1D)
nmr_peak_table <- new_nmr_dataset_peak_table(peak_table, metadata)
se <- nmr_dataset_peak_table_to_SummarizedExperiment(nmr_peak_table)
}
