% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset_1D.R
\name{nmr_export_data_1r}
\alias{nmr_export_data_1r}
\title{Export 1D NMR data to a CSV file}
\usage{
nmr_export_data_1r(nmr_dataset, filename)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D} object}

\item{filename}{The csv filename}
}
\value{
The nmr_dataset object (unmodified)
}
\description{
Export 1D NMR data to a CSV file
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
# nmr_export_data_1r(dataset_1D, "exported_nmr_dataset")
}
