% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruker.R
\name{read_bruker_pdata}
\alias{read_bruker_pdata}
\title{Read processed Bruker NMR data}
\usage{
read_bruker_pdata(
  sample_path,
  pdata_file = NULL,
  pdata_path = "pdata/1",
  all_components = FALSE,
  read_pdata_title = TRUE
)
}
\arguments{
\item{sample_path}{A character path of the sample directory}

\item{pdata_file}{File name of the binary NMR data to load. Usually "1r".
If \code{NULL}, it is autodetected based on the dimension}

\item{pdata_path}{Path from \code{sample_path} to the preprocessed data}

\item{all_components}{If \code{FALSE} load only the real component. Otherwise load the real and imaginary components}

\item{read_pdata_title}{If \code{TRUE} also reads metadata from pdata title file.}
}
\value{
A list with Bruker NMR processed data
}
\description{
Read processed Bruker NMR data
}
\keyword{internal}
