% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_rDolphin_blood.R
\name{save_files_to_rDolphin}
\alias{save_files_to_rDolphin}
\title{Save files to rDoplhin}
\usage{
save_files_to_rDolphin(files_rDolphin, output_directory)
}
\arguments{
\item{files_rDolphin}{a list containing 4 elements from \code{files_to_rDolphin}
\itemize{
\item \code{meta_rDolphin}: metadata in rDolphin format,
\item \code{NMR_spectra}: spectra matrix
\item \code{ROI}: ROI template
\item \code{Parameters_blood}: parameters file
}}

\item{output_directory}{a directory in which the CSV files are saved}
}
\value{
CSV files containing:
}
\description{
The function saves the CSV files required by to_rDolphin and Automatic_targeted_profiling functions for metabolite profiling.
}
\examples{
\dontrun{
dataset <- system.file("dataset-demo", package = "AlpsNMR")
excel_file <- system.file("dataset-demo", "dummy_metadata.xlsx", package = "AlpsNMR")
nmr_dataset <- nmr_read_samples_dir(dataset)
files_rDolphin <- files_to_rDolphin_blood(nmr_dataset)
save_files_to_rDolphin(files_rDolphin, output_directory = ".")
}
}
\seealso{
Other import/export functions: 
\code{\link{Pipelines}},
\code{\link{files_to_rDolphin}()},
\code{\link{load_and_save_functions}},
\code{\link{nmr_data}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_read_bruker_fid}()},
\code{\link{nmr_read_samples}()},
\code{\link{nmr_zip_bruker_samples}()},
\code{\link{save_profiling_output}()},
\code{\link{to_ChemoSpec}()}
}
\concept{import/export functions}
