% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{tidy.nmr_dataset_1D}
\alias{tidy.nmr_dataset_1D}
\title{Get a tidy data frame from nmr_data object}
\usage{
\method{tidy}{nmr_dataset_1D}(
  x,
  NMRExperiment = NULL,
  chemshift_range = NULL,
  columns = character(0L),
  matrix_name = "data_1r",
  axis_name = "axis",
  ...
)
}
\arguments{
\item{x}{an \code{\link{nmr_dataset_1D}} object}

\item{NMRExperiment}{A character vector with the NMRExperiments to include. \code{NULL} means all.}

\item{chemshift_range}{range of the chemical shifts to be included. Can be of length 3
to include the resolution in the third element (e.g. \code{c(0.2, 0.8, 0.005)})}

\item{columns}{A character vector with the metadata columns to get, use \code{NULL} to get all of them.}

\item{matrix_name}{A string with the matrix name, typically "data_1r"}

\item{axis_name}{A string with the axis name, for now "axis" is the only valid option}

\item{...}{Ignored}
}
\value{
A data frame with \code{NMRExperiment}, \code{chemshift}, \code{intensity} and any additional column requested
}
\description{
This dataframe is useful for plotting with ggplot, although it may be very
long and therefore use a lot of RAM.
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -1.0, max = 1.6, by = 2.3E-4))
dummy_metadata <- system.file("dataset-demo", "dummy_metadata.xlsx", package = "AlpsNMR")
NMRExp_SubjID <- readxl::read_excel(dummy_metadata, sheet = 1)
dataset_1D <- nmr_meta_add(dataset_1D, NMRExp_SubjID)
df_for_ggplot <- tidy(dataset_1D, chemshift_range = c(1.2, 1.4), columns = "SubjectID")
head(df_for_ggplot)
}
