% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avtable-methods.R
\name{avtable-methods}
\alias{avtable-methods}
\alias{avtables}
\alias{avtable}
\alias{avtable_import}
\alias{avtable_import_set}
\alias{avtable_delete_values}
\alias{avtables,gcp-method}
\alias{avtable,gcp-method}
\alias{avtable_import,gcp-method}
\alias{avtable_import_set,gcp-method}
\alias{avtable_delete,gcp-method}
\alias{avtable_delete_values,gcp-method}
\title{Methods that work with the primary datasets in the DATA tab}
\usage{
\S4method{avtables}{gcp}(
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  ...,
  platform = cloud_platform()
)

\S4method{avtable}{gcp}(
  table,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  na = c("", "NA"),
  ...,
  platform = cloud_platform()
)

\S4method{avtable_import}{gcp}(
  .data,
  entity = names(.data)[[1L]],
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  delete_empty_values = FALSE,
  na = "NA",
  n = Inf,
  page = 1L,
  pageSize = NULL,
  ...,
  platform = cloud_platform()
)

\S4method{avtable_import_set}{gcp}(
  .data,
  origin,
  set = names(.data)[[1]],
  member = names(.data)[[2]],
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  delete_empty_values = FALSE,
  na = "NA",
  n = Inf,
  page = 1L,
  pageSize = NULL,
  ...,
  platform = cloud_platform()
)

\S4method{avtable_delete}{gcp}(
  table,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  ...,
  platform = cloud_platform()
)

\S4method{avtable_delete_values}{gcp}(
  table,
  values,
  namespace = avworkspace_namespace(),
  name = avworkspace_name(),
  ...,
  platform = cloud_platform()
)
}
\arguments{
\item{namespace}{\code{character(1)} AnVIL workspace namespace as returned
by, e.g., \code{avworkspace_namespace()}}

\item{name}{\code{character(1)} AnVIL workspace name as returned by, eg.,
\code{avworkspace_name()}.}

\item{...}{Additional arguments passed to lower level functions (not used).}

\item{platform}{\code{gcp()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"gcp"} class for Google Cloud Platform
workspaces on AnVIL.}

\item{table}{character(1) table name as returned by, e.g., \code{avtables()}.}

\item{na}{in \code{avtable()} and \code{avtable_paged()}, character() of
strings to be interpretted as missing values. In
\code{avtable_import()} character(1) value to use for representing
\code{NA_character_}. See Details.}

\item{.data}{A tibble or data.frame for import as an AnVIL table.}

\item{entity}{\code{character(1)} column name of \code{.data} to be used as
imported table name. When the table comes from R, this is
usually a column name such as \code{sample}. The data will be
imported into AnVIL as a table \code{sample}, with the \code{sample}
column included with suffix \verb{_id}, e.g., \code{sample_id}. A column
in \code{.data} with suffix \verb{_id} can also be used, e.g., \code{entity = "sample_id"}, creating the table \code{sample} with column
\code{sample_id} in AnVIL. Finally, a value of \code{entity} that is not
a column in \code{.data}, e.g., \code{entity = "unknown"}, will cause a
new table with name \code{entity} and entity values
\code{seq_len(nrow(.data))}.}

\item{delete_empty_values}{logical(1) when \code{TRUE}, remove entities
not include in \code{.data} from the DATA table. Default: \code{FALSE}.}

\item{n}{numeric(1) maximum number of rows to return}

\item{page}{integer(1) first page of iteration}

\item{pageSize}{integer(1) number of records per page. Generally,
larger page sizes are more efficient.}

\item{origin}{character(1) name of the entity (table) used to
create the set e.g "sample", "participant",
etc.}

\item{set}{\code{character(1)} column name of \code{.data} identifying the
set(s) to be created.}

\item{member}{\code{character()} vector of entity from the avtable
identified by \code{origin}. The values may repeat if an ID is in
more than one set}

\item{values}{vector of values in the entity (key) column of
\code{table} to be deleted. A table \code{sample} has an associated
entity column with suffix \verb{_id}, e.g., \code{sample_id}. Rows with
entity column entries matching \code{values} are deleted.}
}
\value{
\code{avtables()}: A tibble with columns identifying the table,
the number of records, and the column names.

\code{avtable()}: a tibble of data corresponding to the AnVIL
table \code{table} in the specified workspace.

\code{avtable_import_set()} returns a \code{character(1)} name of the
imported AnVIL tibble.

\code{avtable_delete()} returns \code{TRUE} if the table is successfully
deleted.

\code{avtable_delete_values()} returns a \code{tibble} representing
deleted entities, invisibly.
}
\description{
Tables can be visualized under the DATA tab, TABLES
item.  \code{avtable()} returns an AnVIL table.  \code{avtable_paged()}
retrieves an AnVIL table by requesting the table in 'chunks',
and may be appropriate for large tables. \code{avtable_import()}
imports a data.frame to an AnVIL table.  \code{avtable_import_set()}
imports set membership (i.e., a subset of an existing table)
information to an AnVIL table.  \code{avtable_delete_values()}
removes rows from an AnVIL table.
}
\details{
Treatment of missing values in \code{avtable()},
\code{avtable_paged()} and \code{avtable_import()} are handled by the
\code{na} parameter.

\code{avtable()} may sometimes result in a curl error 'Error in
curl::curl_fetch_memory' or a 'Internal Server Error (HTTP
500)' This may be due to a server time-out when trying to read
a large (more than 50,000 rows?) table; using \code{avtable_paged()}
may address this problem.

For \code{avtable()} and \code{avtable_paged()}, the default \code{na = c("", "NA")} treats empty cells or cells containing "NA" in a Terra
data table as \code{NA_character_} in R. Use \code{na = character()} to
indicate no missing values, \code{na = "NA"} to retain the
distinction between \code{""} and \code{NA_character_}.

For \code{avtable_import()}, the default \code{na = "NA"} records
\code{NA_character_} in R as the character string \code{"NA"} in an AnVIL
data table.

The default setting (\code{na = "NA"} in \code{avtable_import()},
\verb{na = c("",  NA_character_")} in \code{avtable()}, is appropriate to
'round-trip' data from R to AnVIL and back when character vectors
contain only \code{NA_character_}. Use \code{na = "NA"} in both functions to
round-trip data containing both \code{NA_character_} and "NA". Use
a distinct string, e.g., \code{na = "__MISSING_VALUE__"}, for both
arguments if the data contains a string \code{"NA"} as well as
\code{NA_character_}.

\code{avtable_import()} tries to work around limitations in
\code{.data} size in the AnVIL platform, using \code{pageSize} (number of
rows) to import so that approximately 1500000 elements (rows x
columns) are uploaded per chunk. For large \code{.data}, a progress
bar summarizes progress on the import. Individual chunks may
nonetheless fail to upload, with common reasons being an
internal server error (HTTP error code 500) or transient
authorization failure (HTTP 401). In these and other cases
\code{avtable_import()} reports the failed page(s) as warnings. The
user can attempt to import these individually using the \code{page}
argument. If many pages fail to import, a strategy might be to
provide an explicit \code{pageSize} less than the automatically
determined size.

\code{avtable_import_set()} creates new rows in a table
\verb{<origin>_set}. One row will be created for each distinct value
in the column identified by \code{set}. Each row entry has a
corresponding column \verb{<origin>} linking to one or more rows in
the \verb{<origin>} table, as given in the \code{member} column. The
operation is somewhat like \code{split(member, set)}.
}
\section{Functions}{
\itemize{
\item \code{avtables(gcp)}: \code{avtables()} describes tables available in a
workspace

\item \code{avtable(gcp)}: \code{avtable()} retrieves a table from an AnVIL
workspace

\item \code{avtable_import(gcp)}: upload a table to the DATA tab

\item \code{avtable_import_set(gcp)}: 

\item \code{avtable_delete(gcp)}: Delete a table from the AnVIL workspace.

\item \code{avtable_delete_values(gcp)}: 

}}
\examples{
if (interactive()) {
    avtables("waldronlab-terra", "Tumor_Only_CNV")
    avtable("participant", "waldronlab-terra", "Tumor_Only_CNV")

    library(dplyr)
    ## mtcars dataset
    mtcars_tbl <-
        mtcars |>
        as_tibble(rownames = "model_id") |>
        mutate(model_id = gsub(" ", "-", model_id))

    avworkspace("waldronlab-terra/mramos-wlab-gcp-0")

    avstatus <- avtable_import(mtcars_tbl)

    avtable_import_status(avstatus)

    set_status <- avtable("model") |>
        avtable_import_set("model", "cyl", "model_id")

    avtable_import_status(set_status)

    ## won't be able to delete a row that is referenced in another table
    avtable_delete_values("model", "Mazda-RX4")

    ## delete the set
    avtable_delete("model_set")

    ## then delete the row
    avtable_delete_values("model", "Mazda-RX4")

    ## recreate the set (if needed)
    avtable("model") |>
        avtable_import_set("model", "cyl", "model_id")

}
library(AnVILBase)
if (has_avworkspace(platform = gcp()) && interactive()) {
## editable copy of '1000G-high-coverage-2019' workspace
avworkspace("bioconductor-rpci-anvil/1000G-high-coverage-2019")
sample <-
    avtable("sample") \%>\%                               # existing table
    mutate(set = sample(head(LETTERS), nrow(.), TRUE))  # arbitrary groups
sample \%>\%                                   # new 'participant_set' table
    avtable_import_set("participant", "set", "participant")
sample \%>\%                                   # new 'sample_set' table
    avtable_import_set("sample", "set", "name")
}

}
