% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drs.R
\name{drs}
\alias{drs}
\alias{drs_hub}
\alias{drs_nci_crdc}
\title{DRS (Data Repository Service) URL management}
\usage{
drs_hub(source = character())

drs_nci_crdc(source = character())
}
\arguments{
\item{source}{\code{character()} DRS URLs (beginning with 'drs://') to resources
managed by the DRS Hub server (\code{drs_hub()}).}
}
\value{
\code{drs_hub()} returns a tbl with the following columns:
\itemize{
\item \code{drs}: \code{character()} DRS URIs
\item \code{bucket}: \code{character()} Google cloud bucket
\item \code{name}: \code{character()} object name in \code{bucket}
\item \code{size}: \code{numeric()} object size in bytes
\item \code{timeCreated}: \code{character()} object creation time
\item \code{timeUpdated}: \code{character()} object update time
\item \code{fileName}: \code{character()} local file name
\item \code{accessUrl}: \code{character()} signed URL for object access
}
}
\description{
\code{drs_hub()} resolves zero or more DRS URLs to their Google
bucket location using the DRS Hub API endpoint.
}
\section{drs_hub}{

\code{drs_hub()} uses the DRS Hub API endpoint to resolve a single or multiple DRS
URLs to their Google bucket location. The DRS Hub API endpoint requires a
\code{gcloud_access_token()}. The DRS Hub API service is hosted at
\url{https://drshub.dsde-prod.broadinstitute.org}.
}

\section{drs_nci_crdc}{
 \code{drs_nci_crdc()} resolves one or more DRS URLs to
their <gdc.cancer.gov> location. The implementation allows the extraction
of \code{access_url} values to download the DRS objects. The DRS NCI CRDC
service is hosted at \url{https://nci-crdc.datacommons.io}.
}

\examples{
if (GCPtools::gcloud_exists() && interactive()) {
    drs_urls <- c(
        "drs://drs.anv0:v2_b3b815c7-b012-37b8-9866-1cb44b597924",
        "drs://drs.anv0:v2_2823eac3-77ae-35e4-b674-13dfab629dc5",
        "drs://drs.anv0:v2_c6077800-4562-30e3-a0ff-aa03a7e0e24f"
    )
    drs_hub(drs_urls)

    drs_nci <- c(
        "drs://nci-crdc.datacommons.io/56e35487-b20f-45ba-8d84-9f16b26c85ea",
        "drs://nci-crdc.datacommons.io/f814f1ec-6850-4ab6-ac0f-df9f77ee185b",
        "drs://nci-crdc.datacommons.io/d9b591d5-7fe8-43fe-b0b3-4fc0f9736866"
    )
    drs_nci_crdc(drs_nci)
}
}
