\name{validationFunctions}
\alias{validationFunctions}

\alias{getSpeciesList}
\alias{validSpecies}
\alias{suggestSpecies}
\alias{getValidSourceTypes}
\alias{checkSpeciesTaxId}
\alias{validDispatchClass}

\title{ValidationFunctions}

\description{
  Functions to assist in the validation process of creating the
  metadata.csv file for Hub Resources
}

\usage{
getSpeciesList(verbose=FALSE)

validSpecies(species, verbose=TRUE)

suggestSpecies(query, verbose=FALSE, op=c("|", "&"))

getValidSourceTypes()

checkSpeciesTaxId(txid, species, verbose=TRUE)

validDispatchClass(dc, verbose=TRUE)
}

\arguments{
  \item{species}{
    species to validate (may be single value or list)
  }
  \item{query}{
    terms to query. Whether AND or OR is determined by argument op.
  }
  \item{verbose}{
    should additional information and useful tips be displayed
  }
  \item{op}{
    Should searching of mulitple terms be conditional OR ("|") or AND
    ("&")
  }
  \item{txid}{taxonomy id (single value or list)}
  \item{dc}{Dispatch class to validate (may be single value or list)}
}

\details{
   \itemize{
     \item getSpeciesList: Provides a list of valid species as
   determined by the GenomeInfoDbData package specData.rda file.

     \item validSpecies: True/False if argument is considered a valid
     species based on the list generated by getSpeciesList. A species
     may be deemed invalid if the capitalization mismatches or
     punctuation mismatches. Use suggestSpecies to find similar terms.

     \item suggestSpecies: Based on a term or multiple terms suggest
     possible valid species.

     \item getValidSourceTypes: returns list of acceptable values for
     SourceType in metadata.csv.  If you think a valid source type
     should be added to the list please reach out to
     maintainer@bioconductor.org

     \item checkSpeciesTaxId: cross validates a list of species and
     taxonomy ids for expected values based on
     \code{GenomeInfoDb::loadTaxonomyDb()}. Warning when there is a
     mismatch.

     \item validDispatchClass: TRUE/FALSE if argument is considered a
     valid DispatchClass based on the currently available methods in
     AnnotationHub. Use \code{AnnotationHub::DispatchClassList()} to see
     the table of currently available methods. If a currently available
     method is not appropriate for your resource, please reach out to
     Lori Shepherd \email{Lori.Shepherd@roswellpark.org} to request a
     new method be added.

   }
}

\value{
  \itemize{
    \item For getSpeciesList: character vector of valid species
    \item For validSpecies: True/False if all species given as argument
    are valid
    \item For suggestSpecies: data.frame of taxonomy id and species name
    of possible valid species based on given query key words.
    \item For getValidSourceTypes: character vector of valid source
    types.
    \item For checkSpeciesTaxId: NULL if check is verfified, If verbose
    is ture a table of suggested values along with the warning.
    \item For validDispatchClass: True/False if all dispatch class given
    as argument are valid
  }
}

\author{Lori Shepherd}

\seealso{
  \itemize{
    \item \link{AnnotationHubMetadata}
    \item \link{makeAnnotationHubMetadata}
  }
}

\examples{

species = getSpeciesList()

# following is TRUE

validSpecies("Homo sapiens")
# followin is FALSE because of starting "h"
validSpecies("homo sapiens")

# can provide multiple, if any are not valid FALSE
# TRUE
validSpecies(c("Homo sapiens", "Canis domesticus"))

suggestSpecies("Canis")

getValidSourceTypes()

checkSpeciesTaxId(1003232, "Edhazardia aedis")
checkSpeciesTaxId(9606, "Homo sapiens")

validDispatchClass("GRanges")
}

\keyword{methods}
