% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialPlot.R
\name{featurePlot}
\alias{featurePlot}
\title{Plot spatial gene expression.}
\usage{
featurePlot(
  sce,
  feature,
  assay.type = "logcounts",
  diverging = FALSE,
  low = NULL,
  high = NULL,
  mid = NULL,
  color = NULL,
  platform = NULL,
  is.enhanced = NULL,
  nsubspots.per.edge = 3,
  ...
)
}
\arguments{
\item{sce}{SingleCellExperiment. If \code{feature} is specified and is a 
string, it must exist as a row in the specified assay of \code{sce}.}

\item{feature}{Feature vector used to color each spot. May be the name of a
gene/row in an assay of \code{sce}, or a vector of continuous values.}

\item{assay.type}{String indicating which assay in \code{sce} the expression
vector should be taken from.}

\item{diverging}{If true, use a diverging color gradient in
\code{featurePlot()} (e.g. when plotting a fold change) instead of a
sequential gradient (e.g. when plotting expression).}

\item{low, mid, high}{Optional hex codes for low, mid, and high values of the
color gradient used for continuous spot values.}

\item{color}{Optional hex code to set color of borders around spots. Set to
\code{NA} to remove borders.}

\item{platform}{Spatial sequencing platform. If "Visium", the hex spot layout
will be used, otherwise square spots will be plotted.\cr
NOTE: specifying this argument is only necessary if \code{sce} was not
created by \code{spatialCluster()} or \code{spatialEnhance()}.}

\item{is.enhanced}{True if \code{sce} contains subspot-level data instead of
spots. Spatial sequencing platform. If true, the respective subspot lattice
for each platform will be plotted.\cr
NOTE: specifying this argument is only necessary if \code{sce} was not
created by \code{spatialCluster()} or \code{spatialEnhance()}.}

\item{nsubspots.per.edge}{Number of subspots per edge of the square. Only
valid when \code{platform} is 'ST' or 'VisiumHD'.}

\item{...}{Additional arguments for \code{geom_polygon()}. \code{size}, to
specify the linewidth of these borders, is likely the most useful.}
}
\value{
Returns a ggplot object.
}
\description{
Plot spatial gene expression.
}
\examples{
sce <- exampleSCE()
featurePlot(sce, "gene_2")

}
\seealso{
Other spatial plotting functions: 
\code{\link{clusterPlot}()}
}
\concept{spatial plotting functions}
