% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{assignToGenes}
\alias{assignToGenes}
\title{Assign binding sites to their hosting genes}
\usage{
assignToGenes(
  object,
  overlaps = c("frequency", "hierarchy", "remove", "keep"),
  overlaps.rule = NULL,
  anno.annoDB = NULL,
  anno.genes = NULL,
  match.geneID = "gene_id",
  match.geneName = "gene_name",
  match.geneType = "gene_type",
  quiet = FALSE
)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object with stored binding sites. This
means that ranges should be > 1}

\item{overlaps}{character; how overlapping gene loci should be handled.}

\item{overlaps.rule}{character vector; a vector of gene type that should
be used to handle overlapping cases in a hierarchical manor. The order of the
vector is the order of the hierarchy.}

\item{anno.annoDB}{an object of class \code{OrganismDbi} that contains
the gene annotation (!!! Experimental !!!).}

\item{anno.genes}{an object of class \code{\link{GenomicRanges}} that represents
the gene ranges directly}

\item{match.geneID}{character; meta column name of the gene ID}

\item{match.geneName}{character; meta column name of the gene name}

\item{match.geneType}{character; meta column name of the gene type}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of class \code{\link{BSFDataSet}} with binding sites having
hosting gene information added to their meta columns.
}
\description{
Function that assigns each binding site in the \code{\link{BSFDataSet}} to its
hosting gene given a gene annotation (\code{anno.annoDB}, \code{anno.genes}).
}
\details{
Regardless of the annotation source that is being used, the respective meta
information about the genes have to be present. They can be set by the
\code{match.geneID}, \code{match.geneName} and \code{match.geneType} arguments.

In the case of overlapping gene annotation, a single binding site will be
associated with multiple genes. The \code{\link{overlaps}} parameter allows
to decide in these cases. Option `frequency` will take the most frequently
observed gene type, option `hierarchy` works in conjunction with a user defined
rule (\code{overlaps.rule}). Options `remove` and `keep` will remove or
keep all overlapping cases, respectively.

Note that if an overlaps exists, but gene types are identical options
`frequency` and `hierarchy` will cause the gene that was seen first to be
selected as representative.

The function is part of the standard workflow performed by \code{\link{BSFind}}.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
# Load GRanges with genes
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
bds = makeBindingSites(object = bds, bsSize = 9)
bds = assignToGenes(bds, anno.genes = gns)

}
\seealso{
\code{\link{BSFind}}, \code{\link{geneOverlapsPlot}},
\code{\link{targetGeneSpectrumPlot}}
}
