% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{bindingSiteDefinednessPlot}
\alias{bindingSiteDefinednessPlot}
\title{Binding site definedness plot}
\usage{
bindingSiteDefinednessPlot(
  object,
  by = c("all", "transcript_region", "gene_type"),
  showN.genes = 5,
  show.others = FALSE
)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}

\item{by}{character; the option by which the plot should be grouped by.
Options are: "all", "transcript_region", "gene_type"}

\item{showN.genes}{numeric; if \code{by} is `gene_type`, then this argument
set the maximum number of groups to be shown in the plot}

\item{show.others}{logical; whether to show 'others' category.}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
Binding site definedness is given by the percent of crosslinks that fall
diretly inside the binding site compare to those around the binding site.
This plotting function shows the distribution of those percentage values
grouped by what is indicated in the \code{by} argument.
}
\details{
If \code{by} = 'all', then all binding site are grouped into one distribution.
For options 'transcript_region' and 'gene_type' binding sites are split into
groups according to the respective assignment. This requires that the respective
assignment function was executed on the dataset prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
load(list.files(files, pattern = ".rds$", full.names = TRUE)[2])
bds = BSFind(bds, anno.genes = gns, anno.transcriptRegionList = regions,
 est.subsetChromosome = "chr22")
bds = calculateSignalToFlankScore(bds)
bindingSiteDefinednessPlot(bds)

}
\seealso{
\code{\link{BSFind}}, \code{\link{calculateSignalToFlankScore}}
}
