% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{duplicatedSitesPlot}
\alias{duplicatedSitesPlot}
\title{Plot the number of overlaps when assigning crosslink sites to genes}
\usage{
duplicatedSitesPlot(object)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the number of crosslink sites with their
respective overlapping rate. The function \code{\link{pureClipGeneWiseFilter}}
is expected to be executed prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
# Load GRanges with genes
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
# apply 5\% gene-wise filter
bds = pureClipGeneWiseFilter(object = bds, anno.genes = gns, cutoff = 0.5,
 overlaps = "keepSingle")
duplicatedSitesPlot(bds)

}
\seealso{
\code{\link{pureClipGeneWiseFilter}}
}
