% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{getSummary}
\alias{getSummary}
\alias{getSummary,BSFDataSet-method}
\title{Accessor method for the summary slot of the BSFDataSet object}
\usage{
getSummary(object, ...)

\S4method{getSummary}{BSFDataSet}(object)
}
\arguments{
\item{object}{a \code{BSFDataSet} object}

\item{...}{additional arguments}
}
\value{
returns the summary information storted in the summary slot after
\code{\link{makeBindingSites}} was run
}
\description{
The summary slot is used to track information of the filtering steps applied
in the \code{\link{makeBindingSites}} function
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

bds <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 1)

getSummary(bds)

}
\seealso{
\code{\link{BSFDataSet}} \code{\link{makeBindingSites}}
}
