% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{mergeSummaryPlot}
\alias{mergeSummaryPlot}
\title{Plot summarized results of the different binding site merging and filtering
steps}
\usage{
mergeSummaryPlot(
  object,
  select = c("all", "filter", "inputRanges", "minClSites", "mergeCrosslinkSites",
    "minCrosslinks", "centerIsClSite", "centerIsSummit"),
  ...
)
}
\arguments{
\item{object}{a BSFDataObject, with the makeBindingSites function already run}

\item{select}{one of "all", "filter", "inputRanges",
"minCLSites", "mergeCrosslinkSites", "minCrosslinks",
"centerIsClSite" or "centerIsSummit".
Defines which parameter is selected for plotting.}

\item{...}{further arguments passed to ggplot}
}
\value{
a plot of type ggplot after the \code{\link{makeBindingSites}}
function was run
}
\description{
Bar charts produced for the different filter steps in the binding site
merging routine. Depending on the selected option (\code{select}) all or
only a user defined filter can be shown.
}
\details{
If \code{object} is a single BSFDataObject a single coverage plot will be
drawn, whereas if it is a list of BSFDataObjects, then faceting is used to
make a plot for each list element.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

# plotting a single object
bds0 <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 1)
mergeSummaryPlot(bds0)

# plotting mulitple obejcts
bds1 <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 1, sub.chr = "chr22")
bds2 <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 3, sub.chr = "chr22")
l = list(`1. bsSize = 3` = bds1, `2. bsSize = 9` = bds2)
mergeSummaryPlot(l, width = 20)

}
\seealso{
\code{\link{makeBindingSites}}
}
