% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{processingStepsTable}
\alias{processingStepsTable}
\title{Create a table of all workflow steps for reporting}
\usage{
processingStepsTable(object, option = c("reduced", "full", "extended"))
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object with stored ranges}

\item{option}{character; how detailed the table should be}
}
\value{
a \code{kableExtra} table
}
\description{
Function that creates a printable table with all steps and numbers for each
of the workflow steps that were carried out.
}
\details{
If \code{\link{option}} is set to `reduced`, only the most necessary information
are collected. Option `full` contains a full list of all options and parameters
that were set in any of the workflow functions. Option `extended` contains
extra information about the binding site merging step.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
# apply 5\% filter
bds = pureClipGlobalFilter(object = bds, cutoff = 0.05)
processingStepsTable(bds)

}
\seealso{
\code{\link{BSFind}}
}
