% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{pureClipGlobalFilterPlot}
\alias{pureClipGlobalFilterPlot}
\title{Plot the PureCLIP score distribution with global cutoff indicator}
\usage{
pureClipGlobalFilterPlot(object)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the PureCLIP score distribution on a log2
scale. The function \code{\link{pureClipGlobalFilter}} is expected to be
executed prior to calling this plot function.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
# apply 5\% filter
bds = pureClipGlobalFilter(object = bds, cutoff = 0.05)
pureClipGlobalFilterPlot(bds)

}
\seealso{
\code{\link{pureClipGlobalFilter}}
}
