% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{reproducibilitySamplesPlot}
\alias{reproducibilitySamplesPlot}
\title{UpSet-plot to that shows how each replicate supports binding sites}
\usage{
reproducibilitySamplesPlot(
  object,
  nIntersections = 20,
  show.title = TRUE,
  text.size = NULL
)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}

\item{nIntersections}{numeric; number of intersection to be shown}

\item{show.title}{logical; if plot title should be visible}

\item{text.size}{numeric; fontsize of all numbers on axis}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the set sizes for each replicate, indicating
how many binding site the specific replicate supports given its specific
threshold. The function \code{\link{reproducibilityFilter}} is expected to be
executed prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
bds = makeBindingSites(object = bds, bsSize = 9)
bds = reproducibilityFilter(bds)
reproducibilitySamplesPlot(bds)

}
\seealso{
\code{\link{reproducibilityFilter}},
\code{\link{reproducibilityFilterPlot}}
}
