% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_filter.R
\name{filter.hail.table.Table}
\alias{filter.hail.table.Table}
\title{filter rows of a hail Table}
\usage{
\method{filter}{hail.table.Table}(.data, ..., .by = NULL, .preserve = FALSE)
}
\arguments{
\item{.data}{instance of hail.table.Table}

\item{\dots}{should include named components `filter` which is a logical vector
with same number of rows as `.data`, `hl`, a reference to a hail environment (Module),
and `placeholder` an arbitrary character(1)}

\item{.by}{not used}

\item{.preserve}{not used}
}
\value{
filtered hail.table.Table reference
}
\description{
filter rows of a hail Table
}
\note{
writes one line of table to disk to retrieve field names

FIXME: uses disk because I don't know how to create a BooleanExpression except by importing.
}
\examples{
hl <- hail_init()
annopath <- path_1kg_annotations()
tab <- hl$import_table(annopath, impute = TRUE)$key_by("Sample")
pick <- rep(FALSE, 3500)
pick[seq_len(10)] <- TRUE
ft <- filter(tab, filter = pick, hl = hl)
ft$count()
ft$head(2L)$collect()
}
